/******************************************************************************
 ** $Id: Annehmer.java 2514 2020-09-13 19:21:59Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

/** Nimmt Anmeldungen entgegen. */
class Annehmer extends Thread {

    /** Puffergre fr die Entgegennahme der Nachrichten. */
    private static final int PUFFERGROESSE = 1000;

    /** Verwalten Property-Change-Listener. */
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    /** Gruppe zwecks Organisation des anfnglichen Turnierbetriebs ber ein Netzwerk. */
    private final InetAddress gruppe;
    {
        InetAddress adresse = null;
        try {
            adresse = InetAddress.getByName(Leitung.ADRESSE);
        } catch (UnknownHostException ereignis) {
            ereignis.printStackTrace();
        }
        gruppe = adresse;
    }
    /** Der Multicast-Socket zwecks Organisation des Turnierbetriebs zwischen den JaFuffy-Instanzen. */
    private final MulticastSocket socket;
    {
        MulticastSocket s = null;
        try {
            s = new MulticastSocket(Leitung.PORT);
            s.joinGroup(gruppe);
        } catch (IOException exception) {
            exception.printStackTrace();
        }
        socket = s;
    }

    @Override
    public void run() {
        byte[] puffer = new byte[PUFFERGROESSE];
        while (true) {
            DatagramPacket paket = new DatagramPacket(puffer, puffer.length);
            try {
                socket.receive(paket);
                ObjectInputStream objektstrom;
                ByteArrayInputStream bytestream = new ByteArrayInputStream(puffer);
                objektstrom = new ObjectInputStream(bytestream);
                Object objekt = objektstrom.readObject();
                pcs.firePropertyChange(objekt.getClass().getSimpleName(), null, objekt);
            } catch (SocketException exception) {
                return;
            } catch (IOException | ClassNotFoundException exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    /**
     * Anmeldung von Bearbeitern.
     *
     * @param bearbeiter
     *            Der Bearbeiter zur nderungsereignis.
     */
    void addPropertyChangeListener(PropertyChangeListener bearbeiter) {
        pcs.addPropertyChangeListener(bearbeiter);
    }

    /**
     * Abmeldung von Bearbeitern.
     *
     * @param bearbeiter
     *            Der Bearbeiter zur nderungsereignis.
     */
    void removePropertyChangeListener(PropertyChangeListener bearbeiter) {
        pcs.removePropertyChangeListener(bearbeiter);
    }

    /** Stoppt die Annahme von Objekten zwecks Organisation eines Turniers ber ein Netzwerk. */
    void stoppe() {
        if (socket.isClosed()) {
            return;
        }
        try {
            socket.leaveGroup(gruppe);
        } catch (IOException ausnahme) {
            ausnahme.printStackTrace();
        }
        socket.close();
    }
}