/******************************************************************************
 ** $Id: Signal.java 1589 2018-11-10 20:36:19Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import javax.sound.sampled.Clip;

import jafuffy.Ressource;

/** Abspielen von Tonsignalen. */
public class Signal {

    /** Akustisches Signal (Fehler). */
    public static final Signal ALARM = new Signal("Alarm.wav");
    /** Akustisches Signal (Warnung). */
    public static final Signal WARNUNG = new Signal("Warnung.wav");

    /** Tonsignal, das abgespielt werden kann. */
    private final Clip clip;

    /**
     * Konstruktor.
     *
     * @param name
     *            Der Name des Signals.
     */
    Signal(final String name) {
        clip = Ressource.clip(name);
    }

    /** Signal abspielen. */
    public void play() {
        if (clip != null) {
            clip.setFramePosition(0);
            clip.start();
        }
    }

}
