/******************************************************************************
 ** $Id: Wurfsetzung.java 2559 2021-01-07 23:20:37Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk.ereignis;

import jafuffy.logik.Kategorie;

/** Der vorliegende Wurf wurde gesetzt. */
public class Wurfsetzung implements Ereignis {

    private static final long serialVersionUID = -7677813943493493493L;

    /** Die Kategorie, welche gesetzt wurde. */
    public final Kategorie kategorie;

    /**
     * Konstruiert das Ereignis zum Setzen des Wurfes.
     *
     * @param kategorie
     *            Die Kategorie des Punktezettels, in die der Wurf gesetzt wird.
     */
    public Wurfsetzung(Kategorie kategorie) {
        this.kategorie = kategorie;
    }

}
