/******************************************************************************
 ** $Id: Plan.java 2537 2021-01-03 17:45:16Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import java.util.ArrayList;
import java.util.LinkedHashSet;

import jafuffy.logik.Name.Typus;
import jafuffy.netzwerk.ereignis.Ereignis;

/** Plan, mit dem ein neues Turnier gestartet werden kann. */
public class Plan implements Ereignis {

    /** Zur Serialisierung. */
    private static final long serialVersionUID = 4459572720327787548L;

    /** Spielregelvariante, die fr das Turnier benutzt wird. */
    final Variante variante;
    /** Spieler, welcher das Turnier erffnet. */
    final int erster;
    /** Hlt fest, wer nach Beendigung eines Spiels das nchste Spiel beginnt. */
    final Beginner beginner;
    /** Maximale Anzahl der Spiele im Turnier. */
    final int maximalanzahl;
    /** Die Namen aller an dem Turnier teilnehmenden Spieler. */
    ArrayList<Name> namen;

    /**
     * Konstruiert den Plan fr ein neues Turnier.
     *
     * @param variante
     *            Spielregelvariante
     * @param namen
     *            Die Namen aller an dem Turnier teilnehmenden Spieler
     * @param erster
     *            Index des Spielers, welcher das Turnier erffnet; von Null an beginnend gezhlt
     * @param beginner
     *            Wer beginnt das nchste Spiel?
     * @param maximalanzahl
     *            Anzahl der Spiele im Turnier (0=unendlich)
     */
    public Plan(ArrayList<Name> namen, Beginner beginner, Variante variante, int maximalanzahl, int erster) {
        this.namen = namen;
        this.beginner = beginner;
        this.variante = variante;
        this.maximalanzahl = maximalanzahl;
        this.erster = erster;
    }

    /**
     * Adaptiert den Plan an den lokalen Austragungsort mit den Vorortnamen.
     *
     * @param vorortnamen
     *            Die Vorortnamen am Austragungsort.
     */
    public void adaptiere(LinkedHashSet<String> vorortnamen) {
        ArrayList<Name> namen = new ArrayList<>();
        for (Name name : this.namen) {
            Typus typus = vorortnamen.contains(name.anzeigename()) ? Typus.SPIELER : Typus.VERTRETER;
            namen.add(new Name(name, typus));
        }
        this.namen = namen;
    }

}
