/******************************************************************************
 ** $Id: Erweitert.java 1646 2019-01-12 05:33:11Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/

package jafuffy.bedienung.auswahl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import jafuffy.logik.Punkte;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Turnier;

/**
 * Auswahl der Zelle, in die das Wrfelresultat gesetzt wird (erweiterte Regeln). Gibt JaFuffy/Joker/Bonus-Meldung aus;
 * fhrt "Zwangssetzung" aus.
 */
@SuppressWarnings("serial")
public class Erweitert extends Klassisch {

    /** Anzeigedauer in Millisekunden der Nachricht bei Joker. */
    private static final int JOKERDELAY = 1500;
    /** Anzeigedauer in Millisekunden der Nachricht fr Belegung im oberen Teil bei Joker und vorhandenem JaFuffy. */
    private static final int ZWANGDELAY = 1500;

    /** Die Auswertung zu dieser Auswahl. */
    private final jafuffy.logik.auswertung.Erweitert auswertung;
    /** Die Analyse zu dieser Auswahl. */
    private final jafuffy.logik.analyse.Erweitert analyse;
    /** Setzen des JaFuffy bei JaFuffy-Joker. */
    private final Timer jokertimer = new Timer(JOKERDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            auswertung.zeigeBonusnachricht(false);
            turnier.setze(Kategorie.JAFUFFY);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };
    /** Erzwungenes Setzen zur Belegung im oberen Teil bei JaFuffy-Joker und belegtem JaFuffy. */
    private final Timer zwangtimer = new Timer(ZWANGDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            auswertung.zeigeSetzzwangnachricht(false);
            auswertung.zeigeBonusnachricht(false);
            turnier.belege(Kategorie.oben(turnier.wuerfel(0).augen()));
            turnier.setze(Kategorie.JAFUFFY);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };

    /**
     * Konstruktor.
     *
     * @param turnier
     *            Das Turnier, fr welches die Auswahl getroffen werden soll.
     */
    public Erweitert(Turnier turnier) {
        super(turnier);
        auswertung = (jafuffy.logik.auswertung.Erweitert) turnier.auswertung();
        analyse = (jafuffy.logik.analyse.Erweitert) auswertung.analyse();
    }

    @Override
    public void reagiereAufWurf() {
        aktualisiere();
        if (analyse.istSetzzwangGegeben(turnier.aktiver())) {
            ((Punkte) tabelle.getModel()).auswaehlbar(false);
            auswertung.zeigeSetzzwangnachricht(true);
            auswertung.zeigeBonusnachricht(true);
            HURRA.play();
            zwangtimer.start();
        } else if (analyse.istJokerVorliegend(turnier.aktiver())) {
            auswertung.zeigeJokernachricht(true);
        }
    }

    @Override
    protected void reagiereAufSetzen() {
        if (analyse.istJokerVorliegend(turnier.aktiver())) {
            turnier.pausiere();
            auswertung.zeigeJokernachricht(false);
            auswertung.zeigeBonusnachricht(true);
            turnier.belege(aktuell);
            HURRA.play();
            jokertimer.start();
        } else {
            turnier.setze(aktuell);
        }
    }

}
