/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.netzwerk;

import jafuffy.netzwerk.Anmeldung;
import jafuffy.netzwerk.Kontakt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;

class Anmelder
extends Timer {
    private static final int ANMELDEPERIODE = 1000;
    private final Kontakt absender;
    private final LinkedHashSet<String> vorortteilnehmer;
    private final DatagramSocket socket;
    private final Wiederholung wiederholung = new Wiederholung();

    Anmelder(Kontakt absender, LinkedHashSet<String> vorortteilnehmer) throws SocketException {
        super(Anmelder.class.getSimpleName());
        this.absender = absender;
        this.vorortteilnehmer = vorortteilnehmer;
        this.socket = new DatagramSocket();
    }

    private synchronized void sende(Object objekt) throws IOException, SocketException {
        ByteArrayOutputStream bytestrom = new ByteArrayOutputStream();
        ObjectOutputStream objektstrom = new ObjectOutputStream(new BufferedOutputStream(bytestrom));
        objektstrom.writeObject(objekt);
        objektstrom.close();
        byte[] bytes = bytestrom.toByteArray();
        bytestrom.close();
        DatagramPacket paket = new DatagramPacket(bytes, bytes.length, InetAddress.getByName("239.255.255.136"), 54815);
        this.socket.send(paket);
    }

    synchronized void setze(byte[] teilnehmerhashwert) {
        this.wiederholung.setze(teilnehmerhashwert);
    }

    synchronized void setze(Kontakt vorsitzkontakt, LocalDateTime vorsitzmeldungszeit) {
        this.wiederholung.setze(vorsitzkontakt, vorsitzmeldungszeit);
    }

    void starte() {
        this.scheduleAtFixedRate((TimerTask)this.wiederholung, 0L, 1000L);
    }

    void stoppe() {
        this.socket.close();
    }

    void verschicke(Object objekt) {
        try {
            this.sende(objekt);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private class Wiederholung
    extends TimerTask {
        private byte[] teilnehmerhashwert;
        private Kontakt vorsitzkontakt;
        private LocalDateTime vorsitzmeldungszeit;

        private Wiederholung() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Anmeldung anmeldung;
                Anmelder anmelder = Anmelder.this;
                synchronized (anmelder) {
                    anmeldung = new Anmeldung(Anmelder.this.absender, Anmelder.this.vorortteilnehmer, this.teilnehmerhashwert, this.vorsitzkontakt, this.vorsitzmeldungszeit);
                }
                Anmelder.this.sende(anmeldung);
            }
            catch (SocketException ausnahme) {
                this.cancel();
            }
            catch (IOException ausnahme) {
                ausnahme.printStackTrace();
            }
        }

        void setze(byte[] teilnehmerhashwert) {
            this.teilnehmerhashwert = teilnehmerhashwert;
        }

        void setze(Kontakt vorsitzkontakt, LocalDateTime vorsitzmeldungszeit) {
            this.vorsitzkontakt = vorsitzkontakt;
            this.vorsitzmeldungszeit = vorsitzmeldungszeit;
        }
    }
}

