/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Beginner;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Punkte;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import jafuffy.logik.Variante;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Analyse;
import jafuffy.logik.auswertung.Auswertung;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Aenderungen;
import jafuffy.netzwerk.Vermittlung;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;
import javax.swing.SwingUtilities;

public class Turnier
extends Aenderungen<Ablauf>
implements Vermittlung.Nachfuehrung,
ActionListener,
Serializable {
    public static final int WUERFELSATZGROESSE = 5;
    public static final int WURFVERSUCHANZAHL = 3;
    private static final int KATEGORIENANZAHL = 13;
    private static final long serialVersionUID = -8157448193770055452L;
    private static final Random ZUFALL = new Random();
    private final Auswertung auswertung;
    private final Beginner beginner;
    private final Fortschritt fortschritt = new Fortschritt();
    private final Fortschritt fortschrittmerker = new Fortschritt();
    private Kategorie kategoriemerker;
    private final int maximalanzahl;
    private transient Punkte punkte;
    private Spieler standmerker;
    private transient Statistik statistik;
    private final ArrayList<Spieler> teilnehmer;
    private ArrayList<Integer> turnierstaende;
    private final Variante variante;
    private ArrayList<ArrayList<Integer>> verlaeufe;
    private final Wuerfel[] wuerfelsatz;

    public Turnier(ArrayList<Spieler> teilnehmer, Beginner beginner, Variante variante, int maximalanzahl, int erster) {
        this.teilnehmer = teilnehmer;
        this.beginner = beginner;
        this.variante = variante;
        this.maximalanzahl = maximalanzahl;
        this.wuerfelsatz = new Wuerfel[5];
        int i = 0;
        while (i < 5) {
            this.wuerfelsatz[i] = new Wuerfel(i + 1);
            ++i;
        }
        this.auswertung = variante.auswertung(this.wuerfelsatz);
        for (Spieler spieler : teilnehmer) {
            spieler.initialisiere();
        }
        this.fortschritt.aktiver = teilnehmer.get(erster);
        this.fortschritt.aktiver.aktiviere();
    }

    @Override
    public void actionPerformed(ActionEvent ereignis) {
        String kommando = ereignis.getActionCommand();
        if (kommando.equals("Gewuerfelt")) {
            this.leere();
            this.reagiere();
        } else if (kommando.equals("Rueckgaengig")) {
            this.annulliere();
        } else if (kommando.equals("Vorschlagen")) {
            this.auswertung.erstelleVorschlag();
        } else if (kommando.equals("Beenden")) {
            this.beende();
        }
    }

    public Spieler aktiver() {
        return this.fortschritt.aktiver;
    }

    public Spieler aktivermerker() {
        return this.fortschrittmerker.aktiver;
    }

    public Auswahl auswahl() {
        return this.variante.auswahl(this);
    }

    public Auswertung auswertung() {
        return this.auswertung;
    }

    public void beende() {
        if (this.fortschritt.aktiver != null) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(this.fortschritt.spielindex == this.maximalanzahl && this.maximalanzahl > 0 ? Ablauf.ENDE : Ablauf.ABBRUCH);
            this.fortschritt.aktiver.beende();
            this.fortschritt.aktiver = null;
        }
    }

    public boolean beendet() {
        return this.fortschritt.aktiver == null;
    }

    public void belege(Kategorie kategorie) {
        this.fortschritt.aktiver.belege(kategorie, this.auswertung.analyse());
    }

    public String beschreibung() {
        String s = new String("Mitspieler: ");
        ListIterator<Spieler> iterator = this.teilnehmer.listIterator();
        while (iterator.hasNext()) {
            s = String.valueOf(s) + iterator.next().anzeigename();
            s = iterator.hasNext() ? String.valueOf(s) + ", " : String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + "\n" + this.auswertung.toString() + ". " + (this.teilnehmer.size() > 1 ? (Object)((Object)this.beginner) + ". " : "");
        s = String.valueOf(s) + (this.maximalanzahl == 0 ? "Beliebig viele Spiele." : "Im " + (this.fortschritt.spielindex + 1) + ". von " + this.maximalanzahl + (this.maximalanzahl != 1 ? " Spielen" : " Spiel") + ".");
        return s;
    }

    public Kategorie kategoriemerker() {
        return this.kategoriemerker;
    }

    public int maximalanzahl() {
        return this.maximalanzahl;
    }

    public void pausiere() {
        this.fireStateChanged(Ablauf.PAUSE);
    }

    public Punkte punkte() {
        return this.punkte;
    }

    @Override
    public void reagiere() {
        this.fireStateChanged(Ablauf.LEERUNG);
        this.fortschritt.aktiver.reagiere();
        this.auswertung.reagiereAufWurf(this.fortschritt.aktiver);
        this.auswertung.aktiviereTipps(false);
        this.fireStateChanged(Ablauf.GEWORFEN);
    }

    public boolean ruecknahmefaehig() {
        return this.fortschrittmerker.aktiver.real();
    }

    @Override
    public void setze(Kategorie kategorie) {
        this.standmerker = this.fortschritt.setze(this.fortschrittmerker, kategorie, this.auswertung.analyse());
        this.kategoriemerker = kategorie;
        this.punkte.benachrichtige(this.fortschritt.aktiver.index());
        this.beendeSetzen();
    }

    public void setzeFort(Statistik statistik) {
        this.statistik = statistik;
        this.auswertung.reagiereAufWurf(this.fortschritt.aktiver);
        this.punkte = new Punkte(this.teilnehmer, this.auswertung);
        if (this.verlaeufe == null) {
            this.verlaeufe = new ArrayList(this.teilnehmer.size());
            this.turnierstaende = new ArrayList(this.teilnehmer.size());
            for (Spieler spieler : this.teilnehmer) {
                this.verlaeufe.add(spieler.index(), new ArrayList());
                this.verlaeufe.get(spieler.index()).add(0);
                this.turnierstaende.add(spieler.index(), 0);
            }
        }
        statistik.verfolge(this.variante, this.maximalanzahl, this.teilnehmer, this.auswertung.mittelwert(), this.auswertung.abweichung(), this.verlaeufe, this.turnierstaende);
    }

    public int spielnummer() {
        return this.fortschritt.spielindex + 1;
    }

    public void starte() {
        this.fireStateChanged(Ablauf.START);
    }

    public ArrayList<Spieler> teilnehmer() {
        return this.teilnehmer;
    }

    public boolean vorschlagbar() {
        return this.fortschritt.aktiver.gewuerfelt();
    }

    public Wuerfel wuerfel(int i) {
        return this.wuerfelsatz[i];
    }

    public Wuerfel[] wuerfelsatz() {
        return this.wuerfelsatz;
    }

    private void annulliere() {
        if (this.fortschritt.kategorienanzahl != this.fortschrittmerker.kategorienanzahl) {
            this.statistik.annulliere();
        }
        this.fortschritt.annulliere(this.fortschrittmerker, this.standmerker, this.kategoriemerker, this.auswertung);
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            wuerfel.darstellungsmodell().setSelected(false);
            ++n2;
        }
        this.fireStateChanged(Ablauf.RUECKGAENGIG);
    }

    private void beendeRunde() {
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.kategorienanzahl = fortschritt.kategorienanzahl + 1;
        this.fortschritt.spielerindex = 0;
        this.statistik.beendeRunde();
    }

    private void beendeSetzen() {
        this.fortschritt.aktiver = this.naechster();
        this.fortschritt.aktiver.aktiviere();
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.spielerindex = fortschritt.spielerindex + 1;
        if (this.fortschritt.spielerindex >= this.teilnehmer.size()) {
            this.beendeRunde();
            if (this.fortschritt.kategorienanzahl >= 13) {
                this.fortschritt.aktiver.beende();
                this.auswertung.aktiviereTipps(false);
                this.fireStateChanged(Ablauf.WECHSEL);
                SwingUtilities.invokeLater(() -> {
                    this.fireStateChanged(Ablauf.RESULTAT);
                    this.beendeSpiel();
                    this.uebergebe();
                });
                return;
            }
        }
        this.uebergebe();
    }

    private void beendeSpiel() {
        Spieler erster = this.eroeffner();
        this.statistik.beendeSpiel();
        for (Spieler spieler : this.teilnehmer) {
            spieler.initialisiere();
        }
        this.fortschritt.aktiver = erster;
        this.fortschritt.aktiver.aktiviere();
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.spielindex = fortschritt.spielindex + 1;
        this.fortschritt.kategorienanzahl = 0;
    }

    private Spieler eroeffner() {
        Spieler eroeffner;
        Spieler verlierer;
        Spieler gewinner = verlierer = this.teilnehmer.get(0);
        for (Spieler spieler : this.teilnehmer) {
            if (spieler.endsumme() < verlierer.endsumme()) {
                verlierer = spieler;
            }
            if (spieler.endsumme() <= gewinner.endsumme()) continue;
            gewinner = spieler;
        }
        switch (this.beginner) {
            case VERLIERER: {
                eroeffner = verlierer;
                break;
            }
            case GEWINNER: {
                eroeffner = gewinner;
                break;
            }
            case REIHUM: {
                eroeffner = this.naechster();
                break;
            }
            case ZUFALL: {
                eroeffner = this.teilnehmer.get(ZUFALL.nextInt(this.teilnehmer.size()));
                break;
            }
            case DERSELBE: {
                eroeffner = this.fortschritt.aktiver;
                break;
            }
            default: {
                eroeffner = null;
            }
        }
        return eroeffner;
    }

    private void leere() {
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            if (wuerfel.darstellungsmodell().isSelected()) {
                wuerfel.wirf();
            }
            ++n2;
        }
    }

    private Spieler naechster() {
        return this.teilnehmer.get((this.fortschritt.aktiver.index() + 1) % this.teilnehmer.size());
    }

    private void uebergebe() {
        if (this.maximalanzahl > 0 && this.fortschritt.spielindex == this.maximalanzahl) {
            this.beende();
        } else if (this.fortschritt.spielindex == this.fortschrittmerker.spielindex) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(Ablauf.FERTIG);
        } else {
            this.fireStateChanged(Ablauf.SPIEL);
        }
    }

    Beginner beginner() {
        return this.beginner;
    }

    Spieler spieler(int i) {
        return this.teilnehmer.get(i);
    }

    private static class Fortschritt
    implements Serializable {
        private static final long serialVersionUID = 8968279815699993227L;
        private Spieler aktiver;
        private int kategorienanzahl = 0;
        private int spielerindex = 0;
        private int spielindex = 0;

        private Fortschritt() {
        }

        void annulliere(Fortschritt schritt, Spieler spieler, Kategorie kategorie, Auswertung auswertung) {
            this.aktiver.beende();
            this.aktiver = schritt.aktiver;
            this.spielerindex = schritt.spielerindex;
            this.spielindex = schritt.spielindex;
            this.kategorienanzahl = schritt.kategorienanzahl;
            this.aktiver.annulliere(spieler, kategorie, auswertung.analyse());
            auswertung.reagiereAufWurf(this.aktiver);
            auswertung.aktiviereTipps(false);
        }

        Spieler setze(Fortschritt schritt, Kategorie kategorie, Analyse analyse) {
            schritt.aktiver = this.aktiver;
            schritt.spielerindex = this.spielerindex;
            schritt.spielindex = this.spielindex;
            schritt.kategorienanzahl = this.kategorienanzahl;
            Spieler spieler = this.aktiver.clone();
            this.aktiver.belege(kategorie, analyse);
            this.aktiver.beende();
            return spieler;
        }
    }
}

