/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung.netzwerk;

import jafuffy.bedienung.Oberflaeche;
import jafuffy.netzwerk.Kontakt;
import jafuffy.netzwerk.Leitung;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Organisation
extends JDialog
implements Leitung.Darstellung {
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private static final int TABELLENHOEHE = 64;
    private static final Color VORORTFARBE = Color.ORANGE.darker().darker();
    private static final int NACHRICHTENANZEIGENHOEHE = 100;
    private static final int EINGABELAENGE = 60;
    private static SimpleAttributeSet IDENTIFIKATIONSFORMAT = new SimpleAttributeSet();
    private static SimpleAttributeSet TEILNEHMERFORMAT = new SimpleAttributeSet();
    private final JButton aufnahme;
    private final JButton abbruch;
    private final JTextField eingabe;
    private final JCheckBox festlegung;
    private final JButton senden;
    private final JTable tabelle;
    private final StyledDocument chatverlauf;
    private final Leitung leitung;

    public Organisation(final Leitung leitung, int vorortteilnehmeranzahl) {
        StyleConstants.setFontSize(IDENTIFIKATIONSFORMAT, 10);
        StyleConstants.setForeground(IDENTIFIKATIONSFORMAT, Color.GREEN.darker().darker());
        StyleConstants.setFontSize(TEILNEHMERFORMAT, 10);
        StyleConstants.setForeground(TEILNEHMERFORMAT, Color.GREEN.darker().darker());
        StyleConstants.setBold(TEILNEHMERFORMAT, true);
        this.aufnahme = new JButton("Aufnahme");
        this.abbruch = new JButton("Abbruch");
        this.eingabe = new JTextField(60);
        this.senden = new JButton("Senden");
        this.tabelle = new JTable(){
            private static final long serialVersionUID = 3921343280732485294L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.chatverlauf = new DefaultStyledDocument();
        this.leitung = leitung;
        this.festlegung = new JCheckBox(String.valueOf(vorortteilnehmeranzahl > 1 ? "Unser" : "Mein") + " Austragungsort legt Turnierbedingungen fest.");
        this.installiere();
        this.setTitle("JaFuffy (Organisation f\u00fcr ein Turnier \u00fcber ein Netzwerk)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.getRootPane().setDefaultButton(this.senden);
        this.setContentPane(this.hauptfeld(vorortteilnehmeranzahl));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ereignis) {
                leitung.actionPerformed(new ActionEvent(Organisation.this.abbruch, 1001, Organisation.this.abbruch.getActionCommand()));
                Organisation.this.dispose();
            }
        });
        this.setModal(true);
        this.pack();
    }

    @Override
    public void aktualisiere() {
        SwingUtilities.invokeLater(() -> {
            this.festlegung.setSelected(this.leitung.vorsitzend());
            boolean bereit = this.leitung.konsistent();
            boolean ausfuehrend = this.leitung.ausfuehrend();
            if (bereit && ausfuehrend) {
                this.aufnahme.setEnabled(true);
                this.aufnahme.setText("Aufnahme");
            } else {
                this.aufnahme.setEnabled(false);
                if (bereit) {
                    this.aufnahme.setText("Aufnahme (inaktiv weil Turniervorsitz delegiert)");
                } else {
                    this.aufnahme.setText("Aufnahme (inaktiv wegen Teilnehmerfeld oder Vorsitz)");
                }
            }
            this.aufnahme.setActionCommand("Aufnahme");
        });
    }

    @Override
    public void folge() {
        this.aufnahme.setEnabled(true);
        this.aufnahme.doClick();
    }

    @Override
    public void zeige(Kontakt kontakt, String teilnehmer, String text) {
        try {
            if (this.chatverlauf.getLength() > 0) {
                this.chatverlauf.insertString(this.chatverlauf.getLength(), "\n", null);
            }
            this.chatverlauf.insertString(this.chatverlauf.getLength(), teilnehmer, TEILNEHMERFORMAT);
            this.chatverlauf.insertString(this.chatverlauf.getLength(), " @ " + kontakt + "\n", IDENTIFIKATIONSFORMAT);
            this.chatverlauf.insertString(this.chatverlauf.getLength(), text, null);
        }
        catch (BadLocationException exception) {
            exception.printStackTrace();
        }
    }

    private JPanel abstimmungsfeld() {
        JPanel abstimmungsfeld = new JPanel(new BorderLayout());
        abstimmungsfeld.add((Component)this.vorsitzfeld(), "First");
        abstimmungsfeld.add((Component)this.nachrichtenfeld(), "Center");
        abstimmungsfeld.add((Component)this.eingabefeld(), "Last");
        return abstimmungsfeld;
    }

    private JPanel eingabefeld() {
        this.senden.setToolTipText("Versendet obige Nachricht von bis zu 60 Zeichen an alle anderen Austragungsorte im selben lokalen Netzwerk wie hier.");
        this.senden.setEnabled(false);
        JPanel eingabefeld = new JPanel(new BorderLayout(0, 2));
        eingabefeld.setToolTipText("Optional k\u00f6nnen hier Nachrichten an alle Austragungsorte versendet werden.");
        eingabefeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Nachrichtenversand"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        eingabefeld.add((Component)this.eingabe, "First");
        eingabefeld.add((Component)this.senden, "Last");
        return eingabefeld;
    }

    private JPanel hauptfeld(int anzahl) {
        JPanel feld = new JPanel(new BorderLayout(0, 4));
        feld.setBorder(new EmptyBorder(8, 8, 8, 8));
        feld.add((Component)this.tabellenfeld(), "First");
        feld.add((Component)this.abstimmungsfeld(), "Center");
        feld.add((Component)this.leiste(), "Last");
        return feld;
    }

    private void installiere() {
        this.aufnahme.addActionListener(this.leitung);
        this.abbruch.addActionListener(this.leitung);
        this.addPropertyChangeListener("Senden", this.leitung);
        AbstractDocument dokument = (AbstractDocument)this.eingabe.getDocument();
        dokument.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            private void kontrolliere() {
                Organisation.this.senden.setEnabled(!Organisation.this.eingabe.getText().isEmpty());
            }
        });
        dokument.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, 0, string, attr)) {
                    return;
                }
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, length, string, attr)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.replace(fb, offset, length, string, attr);
            }

            private boolean gefiltert(DocumentFilter.FilterBypass fb, int offset, int laenge, String string, AttributeSet attr) {
                boolean gefiltert;
                boolean bl = gefiltert = string != null && fb.getDocument().getLength() - laenge + string.length() > 60;
                if (gefiltert) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return gefiltert;
            }
        });
        this.festlegung.setActionCommand("Vorsitz");
        this.festlegung.addActionListener(this.leitung);
        this.eingabe.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    Organisation.this.senden.doClick();
                }
            }
        });
        this.senden.addActionListener(event -> {
            this.firePropertyChange("Senden", null, this.eingabe.getText());
            this.eingabe.setText(null);
        });
        this.tabelle.setModel(this.leitung);
        this.leitung.verknuepfe(this);
    }

    private JPanel leiste() {
        this.aufnahme.setEnabled(false);
        this.aufnahme.setToolTipText("<html><p>Aufnahme der obigen Teilnehmer von den verschiedenen Austragungsorten.</p><p>Es m\u00fcssen mehrere Austragungsorte vorhanden sein,<br>wobei einer davon die Turnierbedingungen festlegen muss.</p><p>Es d\u00fcrfen insgesamt h\u00f6chstens vier Spieler am Turnier teilnehmen,<br>wobei alle Namen verschieden sein m\u00fcssen</p></html>");
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(this.aufnahme);
        leiste.add(this.abbruch);
        return leiste;
    }

    private JScrollPane nachrichtenfeld() {
        JTextPane chatbereich = new JTextPane(this.chatverlauf);
        chatbereich.setPreferredSize(new Dimension(0, 100));
        chatbereich.setEditable(false);
        ((DefaultCaret)chatbereich.getCaret()).setUpdatePolicy(2);
        JScrollPane nachrichtenfeld = new JScrollPane(chatbereich);
        nachrichtenfeld.setToolTipText("Hier k\u00f6nnen alle bislang versendeten Nachrichten nachgelesen werden.");
        nachrichtenfeld.setBorder(BorderFactory.createTitledBorder("Empfangene Nachrichten"));
        return nachrichtenfeld;
    }

    private JScrollPane tabellenfeld() {
        this.tabelle.setPreferredScrollableViewportSize(new Dimension(0, 64));
        this.tabelle.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -7344465602419351802L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent zelle = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String zusatz = "";
                if (Organisation.this.leitung.vorsitzend(row)) {
                    zelle.setFont(zelle.getFont().deriveFont(1));
                    zusatz = "<p>Sie ist zugleich f\u00fcr die Festlegung der Turnierbedingungen vorgesehen.</p>";
                }
                if (Organisation.this.leitung.heimisch(row)) {
                    zelle.setForeground(VORORTFARBE);
                    zelle.setToolTipText("<html><p>Der hiesige Austragungsort, an dessen Ger\u00e4t der oder die Teilnehmer direkt sitzen.</p>" + zusatz + "</html>");
                } else {
                    zelle.setForeground(Color.BLACK);
                    zelle.setToolTipText("<html>Ein weiterer im lokalen Netzwerk gefundener Austragungsort." + zusatz + "</html>");
                }
                return zelle;
            }
        });
        this.tabelle.setCellSelectionEnabled(false);
        this.tabelle.setFocusable(false);
        int spalte = 0;
        while (spalte < this.tabelle.getColumnCount()) {
            this.tabelle.getColumnModel().getColumn(spalte).setPreferredWidth(this.leitung.breite(spalte));
            ++spalte;
        }
        this.tabelle.getTableHeader().setReorderingAllowed(false);
        JScrollPane tabellenfeld = new JScrollPane(this.tabelle);
        tabellenfeld.setToolTipText("<html><p>Die Tabelle listet alle Austragungsorte auf, welche \u00fcber das lokale Netzwerk am Turnier teilnehmen  m\u00f6chten.</p><p>Der durch Fettschrift hervorgehobene Austragungsort bestimmt die Regeln.</p><p>Der hiesige Austragungsort ist farblich hervorgehoben.</p></html>");
        tabellenfeld.setBorder(BorderFactory.createTitledBorder("Alle Austragungsorte"));
        tabellenfeld.setRowHeaderView(this.tabelle.getTableHeader());
        return tabellenfeld;
    }

    private JPanel vorsitzfeld() {
        JLabel hinweis = new JLabel("Festlegender Austragungsort in obiger Tabelle in Fettschrift.");
        hinweis.setForeground(Color.GRAY);
        JPanel vorsitzfeld = new JPanel(new FlowLayout(1, 16, 0));
        vorsitzfeld.setBorder(BorderFactory.createTitledBorder("Meldung zum Turniervorsitz zwecks Festlegung der Turnierbedingungen"));
        vorsitzfeld.add(this.festlegung);
        vorsitzfeld.add(hinweis);
        return vorsitzfeld;
    }
}

