/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Tabelle;
import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Punkte;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Zettel
extends JScrollPane
implements ChangeListener {
    static final ImageIcon[] WUERFEL = new ImageIcon[6];
    private final Eigenschaften eigenschaften;
    private final JPanel zeilenkoepfe;
    private final Setzen setzen;
    private int hoehe;

    static {
        int i = 0;
        while (i <= 5) {
            Zettel.WUERFEL[i] = Grafik.icon("Wuerfelchen" + (i + 1) + ".gif");
            ++i;
        }
        i = 0;
        while (i <= 5) {
            Zettel.WUERFEL[i] = Grafik.icon("Wuerfelchen" + (i + 1) + ".gif");
            ++i;
        }
    }

    Zettel(Eigenschaften eigenschaften, Setzen setzen) {
        this.eigenschaften = eigenschaften;
        this.setCorner("UPPER_LEFT_CORNER", this.erzeugeEcke());
        this.zeilenkoepfe = this.erzeugeZeilenkoepfe();
        this.setzen = setzen;
        this.setzeIcons();
        this.setRowHeaderView(this.zeilenkoepfe);
        this.synchronisiereZeilenhoehen();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: {
                    Auswahl auswahl = ((Turnier)umschlag.quelle()).auswahl();
                    this.getViewport().setView(new Tabelle(this.eigenschaften, ((Turnier)umschlag.quelle()).punkte(), auswahl));
                    this.setzen.addActionListener(auswahl);
                    break;
                }
                case GEWORFEN: {
                    ((Auswahl)tabelle.getDefaultEditor(Object.class)).reagiereAufWurf();
                    break;
                }
                case PAUSE: 
                case WECHSEL: {
                    ((Punkte)tabelle.getModel()).auswaehlbar(false);
                    break;
                }
                case FERTIG: 
                case RUECKGAENGIG: 
                case RESULTAT: {
                    ((Punkte)tabelle.getModel()).auswaehlbar(true);
                    break;
                }
                case VORGESCHLAGEN: {
                    tabelle.getDefaultEditor(Object.class).cancelCellEditing();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.setzen.removeActionListener((Auswahl)tabelle.getDefaultEditor(Object.class));
                    break;
                }
            }
        }
        if (tabelle != null) {
            tabelle.repaint();
        }
    }

    private void aktualisiereTabellengroesse() {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        int breite = tabelle.breite();
        this.hoehe = this.zeilenkoepfe.getPreferredSize().height;
        tabelle.setPreferredScrollableViewportSize(new Dimension(breite, this.hoehe));
    }

    private void aktualisiereZeilenhoehe() {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        if (tabelle != null) {
            int zeile = 0;
            while (zeile < tabelle.getRowCount()) {
                tabelle.setRowHeight(zeile, this.zeilenkoepfe.getComponent(zeile).getHeight());
                ++zeile;
            }
        }
    }

    private JLabel erzeugeEcke() {
        JLabel ecke = new JLabel("JaFuffy");
        ecke.setHorizontalAlignment(0);
        ecke.setToolTipText("Felderl\u00e4uterungen siehe Hilfethemen");
        ecke.setBackground(Color.GRAY.darker());
        ecke.setForeground(Color.WHITE);
        ecke.setOpaque(true);
        ecke.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2));
        return ecke;
    }

    private JPanel erzeugeZeilenkoepfe() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Kategorie[] kategorieArray = Kategorie.values();
        int n = kategorieArray.length;
        int n2 = 0;
        while (n2 < n) {
            Zeilenkopf zeilenkopf;
            Kategorie kategorie = kategorieArray[n2];
            switch (kategorie) {
                case GESAMT: 
                case OSUMME: 
                case USUMME: {
                    zeilenkopf = new ZeilenkopfZwischen();
                    break;
                }
                case ESUMME: {
                    zeilenkopf = new ZeilenkopfEnde();
                    break;
                }
                default: {
                    zeilenkopf = new Zeilenkopf();
                }
            }
            zeilenkopf.setText(kategorie.bezeichnung());
            zeilenkopf.setToolTipText(kategorie.beschreibung());
            zeilenkopf.setFont(zeilenkopf.getFont().deriveFont(1));
            zeilenkopf.setOpaque(true);
            panel.add(zeilenkopf);
            ++n2;
        }
        return panel;
    }

    private void setzeIcons() {
        Kategorie[] kategorieArray = Kategorie.OBEN;
        int n = Kategorie.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            Kategorie kategorie = kategorieArray[n2];
            int ind = kategorie.ordinal();
            Zeilenkopf zeilenkopf = (Zeilenkopf)this.zeilenkoepfe.getComponent(ind);
            zeilenkopf.setHorizontalTextPosition(10);
            zeilenkopf.setIcon(WUERFEL[ind]);
            ++n2;
        }
    }

    private void synchronisiereZeilenhoehen() {
        this.getViewport().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent event) {
                Zettel.this.aktualisiereTabellengroesse();
                Zettel.this.aktualisiereZeilenhoehe();
            }
        });
        this.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Zettel.this.aktualisiereZeilenhoehe();
            }
        });
    }

    private class Zeilenkopf
    extends JLabel {
        private static final int DECKELABSTAND = 4;
        private static final int SEITENABSTAND = 2;

        Zeilenkopf() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.faerbe();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.faerbe();
        }

        protected void faerbe() {
            this.setForeground(Color.DARK_GRAY);
        }
    }

    private class ZeilenkopfEnde
    extends Zeilenkopf {
        private ZeilenkopfEnde() {
        }

        @Override
        protected void faerbe() {
            this.setBackground(Zettel.this.getBackground().darker());
            this.setForeground(Color.BLACK);
        }
    }

    private class ZeilenkopfZwischen
    extends Zeilenkopf {
        private ZeilenkopfZwischen() {
        }

        @Override
        protected void faerbe() {
            Color bg1 = Zettel.this.getBackground();
            Color bg2 = bg1.darker();
            Color neu = new Color((bg1.getRed() + bg2.getRed()) / 2, (bg1.getGreen() + bg2.getGreen()) / 2, (bg1.getBlue() + bg2.getBlue()) / 2);
            this.setBackground(neu);
            this.setForeground(Color.BLACK);
        }
    }
}

