/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.marker;

import com.orsoncharts.Range;
import com.orsoncharts.marker.AbstractMarker;
import com.orsoncharts.marker.MarkerData;
import com.orsoncharts.marker.MarkerLine;
import com.orsoncharts.marker.ValueMarker;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NumberMarker
extends AbstractMarker
implements ValueMarker,
Serializable {
    private double value;
    private String label;
    private Font font;
    private Color labelColor;
    private Anchor2D labelAnchor;
    private transient Stroke stroke;
    private Color lineColor;

    public NumberMarker(double value) {
        this.value = value;
        this.label = null;
        this.font = DEFAULT_MARKER_FONT;
        this.labelColor = DEFAULT_LABEL_COLOR;
        this.stroke = DEFAULT_LINE_STROKE;
        this.lineColor = DEFAULT_LINE_COLOR;
        this.labelAnchor = Anchor2D.CENTER;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.fireChangeEvent();
    }

    @Override
    public Range getRange() {
        return new Range(this.value, this.value);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.font = font;
        this.fireChangeEvent();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.labelColor = color;
        this.fireChangeEvent();
    }

    public Anchor2D getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(Anchor2D anchor) {
        ArgChecks.nullNotPermitted(anchor, "anchor");
        this.labelAnchor = anchor;
        this.fireChangeEvent();
    }

    public Stroke getLineStroke() {
        return this.stroke;
    }

    public void setLineStroke(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.stroke = stroke;
        this.fireChangeEvent();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.lineColor = color;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D g2, MarkerData markerData, boolean reverse) {
        MarkerLine line = markerData.getValueLine();
        g2.setPaint(this.lineColor);
        g2.setStroke(this.stroke);
        Line2D.Double l = new Line2D.Double(line.getStartPoint(), line.getEndPoint());
        g2.draw(l);
        Point2D labelPoint = markerData.getLabelPoint();
        if (labelPoint != null) {
            g2.setFont(this.font);
            g2.setColor(this.labelColor);
            this.drawMarkerLabel(g2, this.label, labelPoint.getX(), labelPoint.getY(), this.labelAnchor, l, reverse);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        hash = 19 * hash + ObjectUtils.hashCode(this.label);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberMarker other = (NumberMarker)obj;
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(other.value)) {
            return false;
        }
        if (!ObjectUtils.equals(this.label, other.label)) {
            return false;
        }
        if (!ObjectUtils.equals(this.font, other.font)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelColor, other.labelColor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.labelAnchor, other.labelAnchor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.stroke, other.stroke)) {
            return false;
        }
        return ObjectUtils.equals(this.lineColor, other.lineColor);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeStroke(this.stroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.stroke = SerialUtils.readStroke(stream);
    }
}

