/******************************************************************************
 ** $Id: Kontakt.java 2533 2021-01-03 13:53:57Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk;

import java.io.Serializable;
import java.net.InetAddress;

/** Kontaktdaten fr den Aufnahme eines Turniers ber ein lokales Netzwerk. */
public class Kontakt implements Serializable, Comparable<Kontakt> {

    private static final long serialVersionUID = 402027374401357074L;

    /** IP-Adresse fr Netzwerkbetrieb. */
    private final InetAddress adresse;
    /** Port-Nummer fr Netzwerkbetrieb. */
    private final int port;

    /**
     * Belegung mit Kontaktdaten.
     *
     * @param adresse
     *            IP-Adresse
     * @param port
     *            Port-Nummer
     */
    Kontakt(InetAddress adresse, int port) {
        this.adresse = adresse;
        this.port = port;
    }

    @Override
    public int compareTo(Kontakt kontakt) {
        return toString().compareTo(kontakt.toString());
    }

    /** */
    @Override
    public boolean equals(Object objekt) {
        if (objekt == null) {
            return false;
        }
        Kontakt kontakt = (Kontakt) objekt;
        return adresse.equals(kontakt.adresse) && port == kontakt.port;
    }

    @Override
    public int hashCode() {
        return toString().hashCode();
    }

    @Override
    public String toString() {
        return adresse + ":" + port;
    }

    /** Liefert IP-Adresse fr den Aufnahme ber ein Netzwerk. */
    InetAddress adresse() {
        return adresse;
    }

    /** Liefert Port-Nummer fr den Aufnahme ber ein Netzwerk. */
    int port() {
        return port;
    }

}
