/******************************************************************************
 ** $Id: Ablauf.java 2619 2021-02-21 17:31:16Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.ereignis;

/** Ereignisse, welche im Laufe eines Turniers auftreten. */
public enum Ablauf {
    /** Das Turnier wird gestartet oder fortgesetzt. */
    START,
    /** Nchstes Spiel im Turnier begonnen. */
    SPIEL,
    /** Der Becher wird geschttelt und geleert, so dass anschlieend ein Wurfergebnis vorliegt. */
    LEERUNG,
    /** Die Wrfel sind soeben geworfen worden, sprich aus dem Becher gefallen. */
    GEWORFEN,
    /** Ein Vorschlag zur Auswahl im Wrfelsatz und der gnstigsten Kategorie zum Setzen liegt vor. */
    VORGESCHLAGEN,
    /**
     * Der aktive Spieler hat sein Wurfergebnis in eine Kategorie des Punktezettels eingetragen und ist damit fertig, so
     * dass der nchste wartende Spieler an der Reihe ist.
     */
    FERTIG,
    /** Pausierung fr die Handhabung von Sonderregeln wie "Im-Hieb" sowie "JaFuffy". */
    PAUSE,
    /** Der letzte Setzvorgang eines Spielers soll rckgngig gemacht werden. */
    RUECKGAENGIG,
    /** Legt einen Wechsel zwischen Spielen ein, so dass Zwischenstnde betrachtet werden knnen. */
    WECHSEL,
    /** Der Zettel ist voll, sprich, ein Resultat liegt vor. */
    RESULTAT,
    /** Das Turnier wird beendet. */
    ENDE,
    /** Das Turnier wird vorzeitig abgebrochen. */
    ABBRUCH
}
