/******************************************************************************
 ** $Id: Kommentierung.java 2611 2021-02-05 00:18:18Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jafuffy.logik.Statistik;
import jafuffy.logik.Statistik.Rang;
import jafuffy.logik.Statistik.Rang.Eintrag;
import jafuffy.logik.ereignis.Aktualisierung;
import jafuffy.logik.ereignis.Umschlag;

/** Klasse zur Eingabe eines Kommentars fr die Bestenliste. */
@SuppressWarnings("serial")
public class Kommentierung extends JOptionPane implements ChangeListener {

    /** Icon fr Eintrag in Bestenlist. */
    private static final ImageIcon BESTER = Grafik.icon("Bester.png");
    /** Schttelgerusch. */
    private static final Geraeusch TADA = new Geraeusch("TaDa.wav");

    /** Spielplatz, in dem der Kommentierungsdialog zentriert wird. */
    private final Spielplatz spielplatz;

    /**
     * Konstruktor.
     *
     * @param spielplatz
     *            Spielplatz, in dem der Kommentierungsdialog zentriert wird.
     */
    public Kommentierung(Spielplatz spielplatz) {
        this.spielplatz = spielplatz;
    }

    /**
     * ChangeEvent eingetreten.
     *
     * @param ce
     *            nderungsereignis im Lebenslauf der Statistik.
     */
    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Aktualisierung.class)) {
            Umschlag<Aktualisierung, Statistik> umschlag = Umschlag.ereignisbehaelter(ce);
            switch (umschlag.ereignis()) {
            case BESTER:
                Statistik statistik = umschlag.quelle();
                kommentiere(statistik.raenge());
            default:
            }
        }
    }

    /**
     * Kommentieren der neuen Bestenlisteneintrge.
     *
     * @param rangmerker
     *            Liste aller betroffenen Rnge
     */
    private void kommentiere(ArrayList<Rang> rangmerker) {
        for (Rang rang : rangmerker) {
            TADA.play();
            Eintrag eintrag = rang.neueintrag();
            if (eintrag.kommentar() == null) {
                String kommentar = (String) showInputDialog(spielplatz,
                        "Gratulation!\n" + eintrag.name() + " ist auf Rang " + rang.rangnummer()
                                + " der Bestenliste!\n\n" + eintrag.name()
                                + ",\ndiesen Erfolg kannst du hier kommentieren:",
                        "JaFuffy (Aufnahme in Bestenliste)", INFORMATION_MESSAGE, BESTER, null, null);
                eintrag.kommentiere(kommentar);
            }
        }
    }
}
