/******************************************************************************
 ** $Id: Wurfergebnis.java 2612 2021-02-06 20:37:31Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk.ereignis;

/** Das Ergebnis fr einen Wrfel nach einem Wurf. */
public class Wurfergebnis implements Ereignis {

    private static final long serialVersionUID = 1956586557922139913L;

    /** Index des geworfenen Wrfels. */
    public final int index;
    /** Erzielte Augenzahl des geworfenen Wrfels. */
    public final int augen;

    /**
     * Konstruiert das Wurfergebnis fr eine eine bermittlung ber ein Netzwerk.
     *
     * @param index
     *            Der global eindeutige Index des Wrfels.
     * @param augen
     *            Die erwrfelten Augen.
     */
    public Wurfergebnis(int index, int augen) {
        this.index = index;
        this.augen = augen;
    }

}
