/******************************************************************************
 ** $Id: Aenderungen.java 2526 2021-01-01 15:43:12Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.ereignis;

import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/**
 * Speichert Objekte, die an einem nderungsereignis interessiert sind, und benachrichtigt diese.
 *
 * @param <E>
 *            Typ des nderungsereignisses.
 */
public class Aenderungen<E> {

    /**
     * Liste aller Beobachter. Der Inhalt bestehend aus den Listenelementen wird nicht serialisiert, weil er bei jedem
     * Programmlauf neu zusammengestellt wird.
     */
    private transient EventListenerList liste = new EventListenerList();

    /**
     * Fge Beobachter hinzu.
     *
     * @param beobachter
     *            Beobachter eines nderungsereignisses.
     */
    public void addChangeListener(ChangeListener beobachter) {
        liste.add(ChangeListener.class, beobachter);
    }

    /**
     * Entferne Beobachter.
     *
     * @param beobachter
     *            Beobachter eines nderungsereignisses.
     */
    public void removeChangeListener(ChangeListener beobachter) {
        liste.remove(ChangeListener.class, beobachter);
    }

    /**
     * Benachrichtige Beobachter ber ein erfolgtes Ereignis. Achtung: Empfnger des Ereignisses drfen kein Ereignis
     * abfeuern!
     *
     * @param ereignis
     *            Das erfolgte Ereignis, welches verteilt wird.
     */
    public void fireStateChanged(E ereignis) {
        Umschlag<E, Aenderungen<E>> umschlag = new Umschlag<>(this, ereignis);
        if (liste != null) {
            Object[] listeners = liste.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] == ChangeListener.class) {
                    ((ChangeListener) listeners[i + 1]).stateChanged(umschlag);
                }
            }
        }
    }

}
