/******************************************************************************
 ** $Id: ImHieb.java 2533 2021-01-03 13:53:57Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.auswertung;

import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Wuerfel;

/** Im-Hieb-Auswertung. Ermittelt die Punktzahl eines Spielers zum vorliegenden Wurfergebnis. Im-Hieb-Erkennung. */
public class ImHieb extends Klassisch {

    /** Ermglicht Serialisierung. */
    private static final long serialVersionUID = -980946361963868750L;

    /** Die Klasse der Auswahl, die zu dieser Auswertung passt. */
    public static final Class<? extends Auswahl> AUSWAHLKLASSE = jafuffy.bedienung.auswahl.ImHieb.class;
    /** Regelname. */
    public static final String REGEL = "Im-Hieb-Regeln";

    /** Standardabweichung als grobe Schtzung fr das mittlere Spielergebnis. */
    private static final int ABWEICHUNG = 45;
    /** Erwartete Punktzahl pro Spiel als grobe Schtzung. */
    private static final int MITTELWERT = 235;

    /** Soll Nachricht "Im Hieb!" in Tabelle erscheinen? */
    private boolean istImHiebNachrichtSichtbar = false;
    /** Der Eintrag, fr den die Nachricht "Im Hieb!" erscheinen soll. */
    private Kategorie imHiebEintrag;

    /**
     * Konstruktor.
     *
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     */
    public ImHieb(Wuerfel[] wuerfel) {
        super(wuerfel, new jafuffy.logik.analyse.ImHieb(wuerfel));
    }

    @Override
    public int abweichung() {
        return ABWEICHUNG;
    }

    /**
     * Aktiviert die Im-Hieb-Nachricht.
     *
     * @param kategorie
     *            Die Nachricht wird fr diesen Eintrag aktiviert.
     */
    public void aktiviereImHiebNachricht(Kategorie kategorie) {
        this.imHiebEintrag = kategorie;
        istImHiebNachrichtSichtbar = true;
    }

    /** Deaktiviert die Im-Hieb-Nachricht. */
    public void deaktiviereImHiebNachricht() {
        istImHiebNachrichtSichtbar = false;
    }

    @Override
    public int mittelwert() {
        return MITTELWERT;
    }

    @Override
    public String text(Kategorie kategorie) {
        return istImHiebNachrichtSichtbar && kategorie == imHiebEintrag ? "Im Hieb!" : null;
    }

    @Override
    public String toString() {
        return REGEL;
    }

}
