/******************************************************************************
 ** $Id: Bot.java 2520 2020-12-31 13:22:45Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import java.util.Arrays;

import jafuffy.Eigenschaften;

/** Roboter, welcher die Rolle des Spielers bernimmt. */
public class Bot extends Spieler {

    /** Objekt ist serialisierbar. */
    private static final long serialVersionUID = 9219523837494133853L;

    /** Aufzhlung der verfgbaren Spielstrken fr die Bots. */
    public enum Staerke {
        /** Schwach. */
        SCHWACH("schwach"),
        /** Mig. */
        MAESSIG("mig"),
        /** Gut. */
        GUT("gut"),
        /** Stark. */
        STARK("stark");

        /** Die lesbare Bezeichnung der Spielstrke. */
        private final String bezeichnung;

        /**
         * Konstruktion mit einer lesbaren Bezeichnung.
         *
         * @param bezeichnung
         *            Die lesbare Bezeichnung.
         */
        Staerke(String bezeichnung) {
            this.bezeichnung = bezeichnung;
        }

        @Override
        public String toString() {
            return bezeichnung;
        }
    }

    /** Anzeigenamen fr die Spieler, die von der knstlichen Intelligenz betrieben werden. */
    public static final String[] BOTNAMEN = { "Annabot", "Bennobot", "Clarabot", "Dragobot" };

    /** Anzahl der verfgbaren Strkeintervalle. */
    private static final int N = Bot.Staerke.values().length - 1;
    /** Maximale Unsicherheit. */
    private static final double MAXIMUM = 1;
    /** Schrittweite fr Spielstrkenverteilung. */
    private static final double SCHRITT = MAXIMUM / N;

    /** Grad der Unsicherheit. */
    private final double unsicherheit;

    /**
     * Konstruktor.
     *
     * @param name
     *            Name des Bots.
     * @param eigenschaften
     *            Die von diesem Bot verwendeten allgemeinen Eigenschaften.
     */
    public Bot(Name name, Eigenschaften eigenschaften) {
        super(name, eigenschaften);
        String botstaerke = eigenschaften.getProperty("Botstaerke" + Arrays.asList(BOTNAMEN).indexOf(anzeigename()));
        int staerkenindex = Staerke.valueOf(botstaerke).ordinal();
        unsicherheit = (N - staerkenindex) * SCHRITT;
    }

    @Override
    public boolean real() {
        return false;
    }

    @Override
    public double unsicherheit() {
        return unsicherheit;
    }

}
