/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.axis;

import com.orsoncharts.Chart3DHints;
import com.orsoncharts.ChartElementVisitor;
import com.orsoncharts.Range;
import com.orsoncharts.axis.AbstractAxis3D;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.LabelOrientation;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.label.CategoryLabelGenerator;
import com.orsoncharts.label.StandardCategoryLabelGenerator;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.marker.CategoryMarkerType;
import com.orsoncharts.marker.Marker;
import com.orsoncharts.marker.MarkerData;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StandardCategoryAxis3D
extends AbstractAxis3D
implements CategoryAxis3D,
Serializable {
    private List<Comparable<?>> categories = new ArrayList();
    private Range range = new Range(0.0, 1.0);
    private boolean inverted;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private boolean firstCategoryHalfWidth = false;
    private boolean lastCategoryHalfWidth = false;
    private double tickMarkLength = 3.0;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint = Color.GRAY;
    private CategoryLabelGenerator tickLabelGenerator;
    private double tickLabelOffset = 5.0;
    private LabelOrientation tickLabelOrientation;
    private int maxTickLabelLevels = 3;
    private double tickLabelFactor = 1.4;
    private Map<String, CategoryMarker> markers;
    private boolean isRowAxis = false;
    private boolean isColumnAxis = false;

    public StandardCategoryAxis3D() {
        this(null);
    }

    public StandardCategoryAxis3D(String label) {
        super(label);
        this.tickMarkStroke = new BasicStroke(0.5f);
        this.tickLabelGenerator = new StandardCategoryLabelGenerator();
        this.tickLabelOrientation = LabelOrientation.PARALLEL;
        this.markers = new LinkedHashMap<String, CategoryMarker>();
    }

    @Override
    public boolean isRowAxis() {
        return this.isRowAxis;
    }

    @Override
    public boolean isColumnAxis() {
        return this.isColumnAxis;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setRange(double lowerBound, double upperBound) {
        this.setRange(new Range(lowerBound, upperBound));
    }

    @Override
    public void setRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        this.range = range;
        this.fireChangeEvent(true);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.fireChangeEvent(true);
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.fireChangeEvent(true);
    }

    public boolean isFirstCategoryHalfWidth() {
        return this.firstCategoryHalfWidth;
    }

    public void setFirstCategoryHalfWidth(boolean half) {
        this.firstCategoryHalfWidth = half;
        this.fireChangeEvent(true);
    }

    public boolean isLastCategoryHalfWidth() {
        return this.lastCategoryHalfWidth;
    }

    public void setLastCategoryHalfWidth(boolean half) {
        this.lastCategoryHalfWidth = half;
        this.fireChangeEvent(true);
    }

    public double getTickMarkLength() {
        return this.tickMarkLength;
    }

    public void setTickMarkLength(double length) {
        this.tickMarkLength = length;
        this.fireChangeEvent(false);
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.tickMarkPaint = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.tickMarkStroke = stroke;
        this.fireChangeEvent(false);
    }

    public CategoryLabelGenerator getTickLabelGenerator() {
        return this.tickLabelGenerator;
    }

    public void setTickLabelGenerator(CategoryLabelGenerator generator) {
        ArgChecks.nullNotPermitted(generator, "generator");
        this.tickLabelGenerator = generator;
        this.fireChangeEvent(false);
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double offset) {
        this.tickLabelOffset = offset;
        this.fireChangeEvent(false);
    }

    public LabelOrientation getTickLabelOrientation() {
        return this.tickLabelOrientation;
    }

    public void setTickLabelOrientation(LabelOrientation orientation) {
        ArgChecks.nullNotPermitted((Object)orientation, "orientation");
        this.tickLabelOrientation = orientation;
        this.fireChangeEvent(false);
    }

    public int getMaxTickLabelLevels() {
        return this.maxTickLabelLevels;
    }

    public void setMaxTickLabelLevels(int levels) {
        this.maxTickLabelLevels = levels;
        this.fireChangeEvent(false);
    }

    public double getTickLabelFactor() {
        return this.tickLabelFactor;
    }

    public void setTickLabelFactor(double factor) {
        this.tickLabelFactor = factor;
        this.fireChangeEvent(false);
    }

    @Override
    public CategoryMarker getMarker(String key) {
        return this.markers.get(key);
    }

    public void setMarker(String key, CategoryMarker marker) {
        CategoryMarker existing = this.markers.get(key);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.markers.put(key, marker);
        if (marker != null) {
            marker.addChangeListener(this);
        }
        this.fireChangeEvent(false);
    }

    public Map<String, CategoryMarker> getMarkers() {
        return new LinkedHashMap<String, CategoryMarker>(this.markers);
    }

    @Override
    public double getCategoryWidth() {
        double length = this.range.getLength();
        double start = this.range.getMin() + this.lowerMargin * length;
        double end = this.range.getMax() - this.upperMargin * length;
        double available = end - start;
        return available / (double)this.categories.size();
    }

    @Override
    public void configureAsRowAxis(CategoryPlot3D plot) {
        ArgChecks.nullNotPermitted(plot, "plot");
        this.categories = plot.getDataset().getRowKeys();
        this.isColumnAxis = false;
        this.isRowAxis = true;
    }

    @Override
    public void configureAsColumnAxis(CategoryPlot3D plot) {
        ArgChecks.nullNotPermitted(plot, "plot");
        this.categories = plot.getDataset().getColumnKeys();
        this.isColumnAxis = true;
        this.isRowAxis = false;
    }

    @Override
    public double getCategoryValue(Comparable<?> category) {
        int index = this.categories.indexOf(category);
        if (index < 0) {
            return Double.NaN;
        }
        double length = this.range.getLength();
        double start = this.range.getMin() + this.lowerMargin * length;
        double end = this.range.getMax() - this.upperMargin * length;
        double available = end - start;
        double categoryCount = this.categories.size();
        if (categoryCount == 1.0) {
            return (start + end) / 2.0;
        }
        if (this.firstCategoryHalfWidth) {
            categoryCount -= 0.5;
        }
        if (this.lastCategoryHalfWidth) {
            categoryCount -= 0.5;
        }
        double categoryWidth = 0.0;
        if (categoryCount > 0.0) {
            categoryWidth = available / categoryCount;
        }
        double adj = this.firstCategoryHalfWidth ? 0.0 : 0.5;
        return start + (adj + (double)index) * categoryWidth;
    }

    @Override
    public double translateToWorld(double value, double length) {
        double p = this.getRange().percent(value, this.isInverted());
        return length * p;
    }

    @Override
    public void draw(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        if (!this.isVisible()) {
            return;
        }
        if (pt0.equals(pt1)) {
            return;
        }
        g2.setStroke(this.getLineStroke());
        g2.setPaint(this.getLineColor());
        Line2D.Float axisLine = new Line2D.Float(pt0, pt1);
        g2.draw(axisLine);
        g2.setPaint(this.tickMarkPaint);
        g2.setStroke(this.tickMarkStroke);
        g2.setFont(this.getTickLabelFont());
        double maxTickLabelWidth = 0.0;
        for (TickData t : tickData) {
            if (this.tickMarkLength > 0.0) {
                Line2D tickLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), this.tickMarkLength, opposingPt);
                g2.draw(tickLine);
            }
            String tickLabel = t.getKeyLabel();
            maxTickLabelWidth = Math.max(maxTickLabelWidth, (double)g2.getFontMetrics().stringWidth(tickLabel));
        }
        double maxTickLabelDim = maxTickLabelWidth;
        if (this.getTickLabelsVisible()) {
            g2.setPaint(this.getTickLabelColor());
            if (this.tickLabelOrientation.equals((Object)LabelOrientation.PERPENDICULAR)) {
                this.drawPerpendicularTickLabels(g2, axisLine, opposingPt, tickData, info, hinting);
            } else if (this.tickLabelOrientation.equals((Object)LabelOrientation.PARALLEL)) {
                maxTickLabelDim = this.drawParallelTickLabels(g2, axisLine, opposingPt, tickData, maxTickLabelWidth, info, hinting);
            }
        } else {
            maxTickLabelDim = 0.0;
        }
        if (this.getLabel() != null) {
            Shape shape = this.drawAxisLabel(this.getLabel(), g2, axisLine, opposingPt, maxTickLabelDim + this.tickMarkLength + this.tickLabelOffset + this.getLabelOffset(), info, hinting);
        }
    }

    @Override
    protected String axisStr() {
        String result = "";
        if (this.isRowAxis) {
            result = "row";
        } else if (this.isColumnAxis) {
            result = "column";
        }
        return result;
    }

    private double drawParallelTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, double maxTickLabelWidth, RenderingInfo info, boolean hinting) {
        int levels = 1;
        LineMetrics lm = g2.getFontMetrics().getLineMetrics("123", g2);
        double height = lm.getHeight();
        if (tickData.size() > 1) {
            Point2D p0 = tickData.get(0).getAnchorPt();
            Point2D pN = tickData.get(tickData.size() - 1).getAnchorPt();
            double availableWidth = pN.distance(p0) * (double)tickData.size() / (double)(tickData.size() - 1);
            int labelsPerLevel = (int)Math.floor(availableWidth / (maxTickLabelWidth * this.tickLabelFactor));
            int levelsRequired = this.maxTickLabelLevels;
            if (labelsPerLevel > 0) {
                levelsRequired = this.categories.size() / labelsPerLevel + 1;
            }
            levels = Math.min(levelsRequired, this.maxTickLabelLevels);
        }
        int index = 0;
        for (TickData t : tickData) {
            int level = index % levels;
            double adj = height * ((double)level + 0.5);
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.tickMarkLength + this.tickLabelOffset + adj, opposingPt);
            double axisTheta = Utils2D.calculateTheta(axisLine);
            TextAnchor textAnchor = TextAnchor.CENTER;
            if (axisTheta >= 1.5707963267948966) {
                axisTheta -= Math.PI;
            } else if (axisTheta <= -1.5707963267948966) {
                axisTheta += Math.PI;
            }
            String tickLabel = t.getKeyLabel();
            if (hinting) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("ref", "{\"type\": \"categoryTickLabel\", \"axis\": \"" + this.axisStr() + "\", \"key\": \"" + t.getKey() + "\"}");
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            Shape bounds = TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, axisTheta, textAnchor);
            if (hinting) {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
            }
            if (info != null) {
                RenderedElement tickLabelElement = new RenderedElement((Object)InteractiveElementType.CATEGORY_AXIS_TICK_LABEL, bounds);
                tickLabelElement.setProperty("label", tickLabel);
                tickLabelElement.setProperty("axis", this.axisStr());
                info.addOffsetElement(tickLabelElement);
            }
            ++index;
        }
        return height * (double)levels;
    }

    private void drawPerpendicularTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        for (TickData t : tickData) {
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.tickMarkLength + this.tickLabelOffset, opposingPt);
            double perpTheta = Utils2D.calculateTheta(perpLine);
            TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
            if (perpTheta >= 1.5707963267948966) {
                perpTheta -= Math.PI;
                textAnchor = TextAnchor.CENTER_RIGHT;
            } else if (perpTheta <= -1.5707963267948966) {
                perpTheta += Math.PI;
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            String tickLabel = t.getKeyLabel();
            if (hinting) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("ref", "{\"type\": \"categoryAxisLabel\", \"axis\": \"" + this.axisStr() + "\", \"key\": \"" + t.getKey() + "\"}");
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            Shape bounds = TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, perpTheta, textAnchor);
            if (hinting) {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
            }
            if (info == null) continue;
            RenderedElement tickLabelElement = new RenderedElement((Object)InteractiveElementType.CATEGORY_AXIS_TICK_LABEL, bounds);
            tickLabelElement.setProperty("label", tickLabel);
            tickLabelElement.setProperty("axis", this.axisStr());
            info.addOffsetElement(tickLabelElement);
        }
    }

    @Override
    public List<TickData> generateTickDataForRows(CategoryDataset3D dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArrayList<TickData> result = new ArrayList<TickData>(this.categories.size());
        for (Comparable<?> key : this.categories) {
            double pos = this.range.percent(this.getCategoryValue(key));
            String label = this.tickLabelGenerator.generateRowLabel(dataset, key);
            result.add(new TickData(pos, key, label));
        }
        return result;
    }

    @Override
    public List<TickData> generateTickDataForColumns(CategoryDataset3D dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        ArrayList<TickData> result = new ArrayList<TickData>(this.categories.size());
        for (Comparable<?> key : this.categories) {
            double pos = this.range.percent(this.getCategoryValue(key));
            String label = this.tickLabelGenerator.generateColumnLabel(dataset, key);
            result.add(new TickData(pos, key, label));
        }
        return result;
    }

    @Override
    public List<MarkerData> generateMarkerData() {
        ArrayList<MarkerData> result = new ArrayList<MarkerData>();
        for (Map.Entry<String, CategoryMarker> entry : this.markers.entrySet()) {
            MarkerData markerData;
            double pos;
            CategoryMarker cm = entry.getValue();
            if (cm == null) continue;
            if (cm.getType().equals((Object)CategoryMarkerType.LINE)) {
                pos = this.getCategoryValue(cm.getCategory());
                markerData = new MarkerData(entry.getKey(), pos);
                markerData.setLabelAnchor(cm.getLabel() != null ? cm.getLabelAnchor() : null);
            } else if (cm.getType().equals((Object)CategoryMarkerType.BAND)) {
                pos = this.getCategoryValue(cm.getCategory());
                double width = this.getCategoryWidth();
                markerData = new MarkerData(entry.getKey(), pos - width / 2.0, false, pos + width / 2.0, false);
                markerData.setLabelAnchor(cm.getLabel() != null ? cm.getLabelAnchor() : null);
            } else {
                throw new RuntimeException("Unrecognised marker: " + (Object)((Object)cm.getType()));
            }
            result.add(markerData);
        }
        return result;
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        for (Marker marker : this.markers.values()) {
            marker.receive(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryAxis3D)) {
            return false;
        }
        StandardCategoryAxis3D that = (StandardCategoryAxis3D)obj;
        if (this.lowerMargin != that.lowerMargin) {
            return false;
        }
        if (this.upperMargin != that.upperMargin) {
            return false;
        }
        if (this.firstCategoryHalfWidth != that.firstCategoryHalfWidth) {
            return false;
        }
        if (this.lastCategoryHalfWidth != that.lastCategoryHalfWidth) {
            return false;
        }
        if (this.tickMarkLength != that.tickMarkLength) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.tickMarkPaint, that.tickMarkPaint)) {
            return false;
        }
        if (!this.tickMarkStroke.equals(that.tickMarkStroke)) {
            return false;
        }
        if (!this.tickLabelGenerator.equals(that.tickLabelGenerator)) {
            return false;
        }
        if (this.tickLabelOffset != that.tickLabelOffset) {
            return false;
        }
        if (!this.tickLabelOrientation.equals((Object)that.tickLabelOrientation)) {
            return false;
        }
        if (this.tickLabelFactor != that.tickLabelFactor) {
            return false;
        }
        if (this.maxTickLabelLevels != that.maxTickLabelLevels) {
            return false;
        }
        if (!this.markers.equals(that.markers)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.tickMarkPaint, stream);
        SerialUtils.writeStroke(this.tickMarkStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.tickMarkPaint = SerialUtils.readPaint(stream);
        this.tickMarkStroke = SerialUtils.readStroke(stream);
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.fireChangeEvent(true);
    }
}

