/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.netzwerk;

import jafuffy.logik.Manager;
import jafuffy.logik.Plan;
import jafuffy.netzwerk.Anmelder;
import jafuffy.netzwerk.Anmeldung;
import jafuffy.netzwerk.Annehmer;
import jafuffy.netzwerk.Bescheid;
import jafuffy.netzwerk.Kontakt;
import jafuffy.netzwerk.Nachricht;
import jafuffy.netzwerk.Vermittlung;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class Leitung
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3855732214488995777L;
    private static final int VERBINDUNGSPERIODE = 1000;
    private static final int VERBINDUNGSVERSUCHE = 3;
    static final int PORT = 54815;
    static final String ADRESSE = "239.255.255.136";
    private final Anmelder anmelder;
    private final Annehmer annehmer;
    private final Vermittlung vermittlung;
    private final Kontakt vorortkontakt;
    private final TreeMap<Kontakt, LinkedHashSet<String>> namengruppen = new TreeMap();
    private final HashMap<Kontakt, Ueberpruefung> ueberpruefungen = new HashMap();
    private final MessageDigest md;
    private final HashMap<Kontakt, byte[]> teilnehmerhashwerte;
    private final Vorsitz vorsitz;
    private LinkedHashSet<String> gesamtnamen;
    private Darstellung darstellung;
    private boolean konsistent;
    private volatile Phase phase;
    private Kontakt[] kontakte;

    public Leitung(Aufnahme aufnahme, Manager manager, LinkedHashSet<String> vorortnamen) throws UnknownHostException, SocketException {
        MessageDigest instanz = null;
        try {
            instanz = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ereignis2) {
            ereignis2.printStackTrace();
        }
        this.md = instanz;
        this.teilnehmerhashwerte = new HashMap();
        this.vorsitz = new Vorsitz();
        this.phase = Phase.ABSTIMMUNG;
        this.kontakte = new Kontakt[4];
        this.vermittlung = manager.vermittlung(plan -> SwingUtilities.invokeLater(() -> {
            aufnahme.folge();
            plan.adaptiere(vorortnamen);
            this.betreibe(manager, plan);
            this.phase = Phase.BETRIEB;
        }));
        this.vorortkontakt = new Kontakt(InetAddress.getLocalHost(), this.vermittlung.socket().getLocalPort());
        this.annehmer = new Annehmer();
        this.anmelder = new Anmelder(this.vorortkontakt, vorortnamen);
        this.annehmer.addPropertyChangeListener(ereignis -> {
            String eigenschaft = ereignis.getPropertyName();
            Object wert = ereignis.getNewValue();
            if (eigenschaft.equals(Anmeldung.class.getSimpleName())) {
                this.verarbeite((Anmeldung)wert);
            } else if (eigenschaft.equals(Nachricht.class.getSimpleName())) {
                this.verarbeite((Nachricht)wert);
            } else if (eigenschaft.equals(Bescheid.class.getSimpleName())) {
                this.verarbeite((Bescheid)wert);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ereignis) {
        String kommando;
        switch (kommando = ereignis.getActionCommand()) {
            case "Aufnahme": {
                this.initiiere(SwingUtilities.getWindowAncestor((Component)ereignis.getSource()));
                break;
            }
            case "Abbruch": {
                this.stoppe(SwingUtilities.getWindowAncestor((Component)ereignis.getSource()));
                break;
            }
            case "Vorsitz": {
                this.bewerbe(((JCheckBox)ereignis.getSource()).isSelected());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ausfuehrend() {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            return this.vorsitz.ausfuehrend();
        }
    }

    public void betreibe(Manager manager, Plan plan) {
        manager.betreibe(plan, this.vermittlung);
    }

    public int breite(int spalte) {
        return Spalte.values()[spalte].breite;
    }

    public LinkedHashSet<String> gesamtnamen() {
        return this.gesamtnamen;
    }

    @Override
    public int getColumnCount() {
        return Spalte.values().length;
    }

    @Override
    public String getColumnName(int spalte) {
        return Spalte.values()[spalte].toString();
    }

    @Override
    public int getRowCount() {
        return this.namengruppen.size();
    }

    @Override
    public Object getValueAt(int zeile, int spalte) {
        String identifikation = this.kontakte[zeile].toString();
        switch (Spalte.values()[spalte]) {
            case IDENTIFIKATION: {
                return identifikation;
            }
            case TEILNEHMER: {
                return this.namengruppen.get(this.kontakte[zeile]);
            }
        }
        return null;
    }

    public boolean heimisch(int zeile) {
        return this.vorortkontakt.equals(this.kontakte[zeile]);
    }

    public void informiere(Plan plan) throws Exception {
        this.vermittlung.verteile(plan);
        this.phase = Phase.BETRIEB;
    }

    public boolean konsistent() {
        return this.konsistent;
    }

    public Phase phase() {
        return this.phase;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ereignis) {
        String eigenschaft = ereignis.getPropertyName();
        Object wert = ereignis.getNewValue();
        if (eigenschaft.equals("Senden")) {
            this.anmelder.verschicke(new Nachricht(this.vorortkontakt, this.vorortnamen(), wert.toString()));
        }
    }

    public void stoppe() {
        this.vermittlung.schliesse();
    }

    public void verknuepfe(Darstellung darstellung) {
        this.darstellung = darstellung;
        new Thread(this.annehmer).start();
        this.anmelder.starte();
    }

    public LinkedHashSet<String> vorortnamen() {
        return this.namengruppen.get(this.vorortkontakt);
    }

    public String vorsitz() {
        return this.namengruppen.get(this.vorsitz.kontakt) + "@" + this.vorsitz.kontakt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vorsitzend() {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            return this.vorsitz.ausfuehrend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vorsitzend(int zeile) {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            return this.vorsitz.ausfuehrend(this.kontakte[zeile]);
        }
    }

    public boolean warte() throws InterruptedException {
        boolean fertig = this.vermittlung.warte();
        this.phase = fertig ? Phase.BEREIT : Phase.ABBRUCH;
        return fertig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beendeAbstimmung() {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            this.anmelder.stoppe();
            this.annehmer.stoppe();
        }
    }

    private void benenne(Kontakt absenderkontakt, Kontakt meldungskontakt, LocalDateTime meldungszeit) {
        if (this.vorsitz.danach(meldungszeit)) {
            if (meldungskontakt == null) {
                if (this.vorsitz.ausfuehrend(absenderkontakt)) {
                    this.vorsitz.setze(null, LocalDateTime.now());
                    this.anmelder.setze(this.vorsitz.kontakt, this.vorsitz.meldungszeit);
                }
            } else if (meldungskontakt.equals(absenderkontakt)) {
                this.vorsitz.setze(meldungskontakt, meldungszeit);
                this.anmelder.setze(this.vorsitz.kontakt, this.vorsitz.meldungszeit);
            }
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bewerbe(boolean bereit) {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            Kontakt kontakt = this.vorortkontakt;
            if (!bereit && (this.vorsitz.ausfuehrend() || this.vorsitz.vakant())) {
                kontakt = null;
            }
            this.anmelder.setze(kontakt, LocalDateTime.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregistriere(Kontakt kontakt) {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            this.ueberpruefungen.remove(kontakt);
            this.namengruppen.remove(kontakt);
            this.kontakte = this.namengruppen.keySet().toArray(new Kontakt[0]);
            this.teilnehmerhashwerte.remove(kontakt);
            this.benenne(kontakt, null, LocalDateTime.now());
            this.hashe();
            this.pruefe();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void hashe() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ByteArrayOutputStream feldstrom = new ByteArrayOutputStream();
                try {
                    try (ObjectOutputStream objektstrom = new ObjectOutputStream(feldstrom);){
                        for (Map.Entry<Kontakt, LinkedHashSet<String>> eintrag : this.namengruppen.entrySet()) {
                            objektstrom.writeObject(eintrag.getKey());
                            objektstrom.writeObject(eintrag.getValue());
                        }
                        byte[] vororthashwert = this.md.digest(feldstrom.toByteArray());
                        this.teilnehmerhashwerte.put(this.vorortkontakt, vororthashwert);
                        this.anmelder.setze(vororthashwert);
                    }
                    if (feldstrom == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (feldstrom == null) throw throwable;
                    feldstrom.close();
                    throw throwable;
                }
                feldstrom.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ausnahme) {
            ausnahme.printStackTrace();
        }
    }

    private void initiiere(Window fenster) {
        fenster.dispose();
        final Bescheid bescheid = new Bescheid();
        Timer timer = new Timer(Leitung.class.getSimpleName());
        timer.schedule(new TimerTask(){
            private int anzahl;

            @Override
            public void run() {
                if (Leitung.this.phase == Phase.ABSTIMMUNG && this.anzahl <= 3) {
                    ++this.anzahl;
                    Leitung.this.anmelder.verschicke(bescheid);
                } else {
                    this.cancel();
                    Leitung.this.beendeAbstimmung();
                    if (Leitung.this.phase == Phase.ABSTIMMUNG) {
                        Leitung.this.vermittlung.schliesse();
                    }
                }
            }
        }, 0L, 1000L);
    }

    private void pruefe() {
        int spieleranzahl = 0;
        for (LinkedHashSet<String> namen : this.namengruppen.values()) {
            spieleranzahl += namen.size();
        }
        this.gesamtnamen = new LinkedHashSet(4);
        for (LinkedHashSet<String> namen : this.namengruppen.values()) {
            this.gesamtnamen.addAll(namen);
        }
        this.konsistent = true;
        boolean vorhanden = false;
        byte[] vororthashwert = this.teilnehmerhashwerte.get(this.vorortkontakt);
        Kontakt[] kontaktArray = this.kontakte;
        int n = this.kontakte.length;
        int n2 = 0;
        while (n2 < n) {
            Kontakt kontakt = kontaktArray[n2];
            vorhanden = vorhanden || this.vorsitz.ausfuehrend(kontakt);
            this.konsistent = this.konsistent && Arrays.equals(vororthashwert, this.teilnehmerhashwerte.get(kontakt));
            ++n2;
        }
        this.konsistent = spieleranzahl <= 4 && spieleranzahl == this.gesamtnamen.size() && this.namengruppen.size() > 1 && vorhanden && this.konsistent;
        this.darstellung.aktualisiere();
    }

    private void registriere(Kontakt kontakt, byte[] teilnehmerhashwert) {
        this.teilnehmerhashwerte.put(kontakt, teilnehmerhashwert);
        this.pruefe();
    }

    private void registriere(Kontakt kontakt, LinkedHashSet<String> vorortteilnehmer, byte[] teilnehmerhashwert) {
        this.namengruppen.put(kontakt, vorortteilnehmer);
        this.kontakte = this.namengruppen.keySet().toArray(new Kontakt[0]);
        this.hashe();
        this.registriere(kontakt, teilnehmerhashwert);
    }

    private void stoppe(Window fenster) {
        this.phase = Phase.ABBRUCH;
        this.beendeAbstimmung();
        fenster.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verarbeite(Anmeldung anmeldung) {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            Ueberpruefung ueberpruefung = this.ueberpruefungen.get(anmeldung.vorortkontakt());
            if (ueberpruefung == null) {
                this.registriere(anmeldung.vorortkontakt(), anmeldung.vorortteilnehmer(), anmeldung.teilnehmerhashwert());
                new Ueberpruefung(anmeldung.vorortkontakt());
                this.fireTableDataChanged();
            } else {
                ueberpruefung.bestaetige();
                this.registriere(anmeldung.vorortkontakt(), anmeldung.teilnehmerhashwert());
            }
            this.benenne(anmeldung.vorortkontakt(), anmeldung.vorsitzkontakt(), anmeldung.vorsitzmeldungszeit());
        }
    }

    private void verarbeite(Bescheid bescheid) {
        if (this.phase == Phase.VERBINDUNG) {
            return;
        }
        this.phase = Phase.VERBINDUNG;
        this.beendeAbstimmung();
        for (Ueberpruefung ueberpruefung : this.ueberpruefungen.values()) {
            ueberpruefung.bestaetige();
            ueberpruefung.cancel();
        }
        this.ueberpruefungen.clear();
        this.vermittlung.verbinde(this.kontakte, this.vorortkontakt);
        if (!this.vorsitzend()) {
            this.darstellung.folge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verarbeite(Nachricht nachricht) {
        Anmelder anmelder = this.anmelder;
        synchronized (anmelder) {
            this.darstellung.zeige(nachricht.vorortkontakt(), nachricht.vorortteilnehmer().toString(), nachricht.text());
        }
    }

    public static interface Aufnahme {
        public void folge();
    }

    public static interface Darstellung {
        public void aktualisiere();

        public void folge();

        public void zeige(Kontakt var1, String var2, String var3);
    }

    public static enum Phase {
        ABSTIMMUNG,
        VERBINDUNG,
        BEREIT,
        BETRIEB,
        ABBRUCH;

    }

    private static enum Spalte {
        TEILNEHMER("Teilnehmer", 250),
        IDENTIFIKATION("Identifikation", 250);

        private final String titel;
        final int breite;

        private Spalte(String titel, int breite) {
            this.titel = titel;
            this.breite = breite;
        }

        public String toString() {
            return this.titel;
        }
    }

    private class Ueberpruefung
    extends TimerTask {
        private static final int UEBERWACHUNGSPERIODE = 2000;
        private final Kontakt kontakt;
        private boolean vorhanden;
        private final Timer ueberwachung;

        Ueberpruefung(Kontakt kontakt) {
            this.kontakt = kontakt;
            Leitung.this.ueberpruefungen.put(kontakt, this);
            this.ueberwachung = new Timer(Ueberpruefung.class.getSimpleName());
            this.ueberwachung.schedule((TimerTask)this, 2000L, 2000L);
        }

        @Override
        public synchronized void run() {
            if (!this.vorhanden) {
                this.ueberwachung.cancel();
                Leitung.this.deregistriere(this.kontakt);
                Leitung.this.fireTableDataChanged();
            }
            this.vorhanden = false;
        }

        synchronized void bestaetige() {
            this.vorhanden = true;
        }
    }

    private class Vorsitz {
        private Kontakt kontakt;
        private LocalDateTime meldungszeit;

        private Vorsitz() {
        }

        boolean ausfuehrend() {
            return this.ausfuehrend(Leitung.this.vorortkontakt);
        }

        boolean ausfuehrend(Kontakt kontakt) {
            return kontakt != null && kontakt.equals(this.kontakt);
        }

        boolean danach(LocalDateTime meldungszeit) {
            return meldungszeit != null && (this.meldungszeit == null || meldungszeit.isAfter(this.meldungszeit));
        }

        void setze(Kontakt kontakt, LocalDateTime meldungszeit) {
            this.kontakt = kontakt;
            this.meldungszeit = meldungszeit;
            Leitung.this.pruefe();
        }

        boolean vakant() {
            return this.kontakt == null;
        }
    }
}

