/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

public final class Kombinatorik {
    public static final int VARIATIONEN = 7776;
    public static final double AUSLASSUNGSWAHRSCHEINLICHKEIT = 0.8333333333333334;
    private static final double[] AUGENZAHLEN = new double[]{0.0, 3.5, 4.25, 4.666666666666667};
    private static final double[] HIEBGLEICHENWAHRSCHEINLICHKEIT = new double[]{0.0, 0.09259259259259259, 0.6944444444444444, 0.19290123456790123, 0.019290123456790122, 7.716049382716049E-4};
    private static final float[][] MEHRLINGSKUMULATIONSWAHRSCHEINLICHKEITEN = new float[][]{{1.0f, 0.9350945f, 0.6988386f, 0.35485f, 0.1044263f, 0.0132721f}, {1.0f, 0.9998518f, 0.9920864f, 0.940559f, 0.7902726f, 0.5417243f, 0.2833378f, 0.1069301f, 0.0272795f, 0.0042049f, 2.956E-4f}, {1.0f, 1.0f, 0.9999928f, 0.9995734f, 0.9943353f, 0.9659221f, 0.8793388f, 0.7107106f, 0.485143f, 0.2691175f, 0.1176685f, 0.0393608f, 0.0096959f, 0.0016566f, 1.754E-4f, 8.7E-6f}, {1.0f, 1.0f, 1.0f, 0.9999999f, 0.9999901f, 0.9997585f, 0.9973869f, 0.984401f, 0.9404578f, 0.839674f, 0.6734907f, 0.4687962f, 0.2757569f, 0.1342929f, 0.0531735f, 0.0167854f, 0.0041185f, 7.567E-4f, 9.8E-5f, 8.0E-6f, 3.0E-7f}, {1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9999999f, 0.9999958f, 0.9999126f, 0.9990586f, 0.9939964f, 0.9745622f, 0.9223102f, 0.8185786f, 0.6609259f, 0.4728535f, 0.2937102f, 0.155939f, 0.0698569f, 0.0260761f, 0.0079963f, 0.0019781f, 3.849E-4f, 5.67E-5f, 6.0E-6f, 4.0E-7f, 0.0f}, {1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9999988f, 0.999975f, 0.9997136f, 0.9979953f, 0.9904755f, 0.9669456f, 0.9116353f, 0.8105129f, 0.6631048f, 0.4886861f, 0.319012f, 0.1821067f, 0.089973f, 0.0381218f, 0.0137222f, 0.0041509f, 0.0010409f, 2.124E-4f, 3.44E-5f, 4.2E-6f, 4.0E-7f, 0.0f, 0.0f}};
    private static final int[][] STIRLING2 = new int[6][];

    static {
        Kombinatorik.STIRLING2[0] = new int[1];
        Kombinatorik.STIRLING2[0][0] = 1;
        int n = 1;
        while (n <= 5) {
            Kombinatorik.STIRLING2[n] = new int[n + 1];
            Kombinatorik.STIRLING2[n][0] = 0;
            int k = 1;
            while (k < n) {
                Kombinatorik.STIRLING2[n][k] = k * STIRLING2[n - 1][k] + STIRLING2[n - 1][k - 1];
                ++k;
            }
            Kombinatorik.STIRLING2[n][n] = 1;
            ++n;
        }
    }

    public static double augenzahl(int r) {
        return AUGENZAHLEN[r];
    }

    public static double augenzahl(int a, int r) {
        return Double.max(a, Kombinatorik.augenzahl(r));
    }

    public static int binom(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (2 * k > n) {
            return Kombinatorik.binom(n, n - k);
        }
        int koeffizient = 1;
        n -= k;
        int i = 1;
        while (i <= k) {
            koeffizient *= ++n;
            koeffizient /= i;
            ++i;
        }
        return koeffizient;
    }

    public static int fakultaet(int n) {
        int p = 1;
        while (n > 0) {
            p *= n;
            --n;
        }
        return p;
    }

    public static int fallend(int n, int k) {
        int p;
        if (k < 0) {
            p = 0;
        } else {
            p = 1;
            int i = 0;
            while (i < k) {
                p *= n;
                ++i;
                --n;
            }
        }
        return p;
    }

    public static double fixgleichenmittel(int n, int r) {
        return (double)n * Kombinatorik.fixgleichenwahrscheinlichkeit(1, r);
    }

    public static double fixgleichenwahrscheinlichkeit(int n, int r) {
        return Kombinatorik.fixgleichenwahrscheinlichkeit(n, n, r);
    }

    public static double fixgleichenwahrscheinlichkeit(int n, int m, int r) {
        double p = 1.0 - Math.pow(0.8333333333333334, r);
        return (double)Kombinatorik.binom(n, m) * Math.pow(p, m) * Math.pow(1.0 - p, n - m);
    }

    public static double gleichenwahrscheinlichkeit(int m) {
        return HIEBGLEICHENWAHRSCHEINLICHKEIT[m];
    }

    public static float mehrlingskumulationswahrscheinlichkeit(int f, int m) {
        if (f == 0 && m == 0) {
            return 1.0f;
        }
        if (f == 0 || m > 5 * f) {
            return 0.0f;
        }
        return MEHRLINGSKUMULATIONSWAHRSCHEINLICHKEITEN[f - 1][m];
    }

    public static double mehrlingswahrscheinlichkeit(int a, int m) {
        if (m == 2) {
            return (25.0 + (double)(5 * (a - 1))) / 324.0;
        }
        return Kombinatorik.gleichenwahrscheinlichkeit(m) / 6.0;
    }

    public static double mindestfixgleichenwahrscheinlichkeit(int min) {
        return Kombinatorik.mindestfixgleichenwahrscheinlichkeit(5, min, 3);
    }

    public static double mindestfixgleichenwahrscheinlichkeit(int n, int min, int r) {
        double p = 0.0;
        int k = min;
        while (k <= 5) {
            p += Kombinatorik.fixgleichenwahrscheinlichkeit(n, k, r);
            ++k;
        }
        return p;
    }

    public static double mindestgleichenwahrscheinlichkeit(int min) {
        double p = 0.0;
        int k = min;
        while (k <= 5) {
            p += Kombinatorik.gleichenwahrscheinlichkeit(k);
            ++k;
        }
        return p;
    }

    public static double mindestmehrlingswahrscheinlichkeit(int a, int m) {
        double p = 0.0;
        int k = m;
        while (k <= 5) {
            p += Kombinatorik.mehrlingswahrscheinlichkeit(a, k);
            ++k;
        }
        return p;
    }

    public static int stirling2(int n, int k) {
        if (k <= n) {
            return STIRLING2[n][k];
        }
        return 0;
    }

    public static int strassenteilschablone(int n, int d, int k) {
        int summe = 0;
        int j = k;
        while (j <= n) {
            summe = (int)((double)summe + (double)(Kombinatorik.stirling2(j, k) * Kombinatorik.binom(n, j)) * Math.pow(d, n - j));
            ++j;
        }
        return summe;
    }

    public static double strassenteilsequenz(int n, int d, int k, int m) {
        return Kombinatorik.fallend(m, k) * Kombinatorik.strassenteilschablone(n, d, k);
    }

    private Kombinatorik() {
    }
}

