/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Kategorie;
import jafuffy.logik.Spieler;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Analyse;
import jafuffy.logik.analyse.Kombinatorik;
import jafuffy.logik.analyse.Strasse;
import java.util.ArrayList;

public class Klassisch
extends Analyse {
    private static final long serialVersionUID = -3852043350163717864L;

    public Klassisch(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    protected Analyse.Eintragungen eintragungen() {
        return new Eintragungen();
    }

    class Dreierpasch
    extends Analyse.Pasch {
        private static final long serialVersionUID = 1347995442616468479L;
        private static final int PASCHGROESSE = 3;

        Dreierpasch() {
            super(3);
        }

        @Override
        protected double augensumme(int a, int r, int k) {
            if (k != 2) {
                throw new IllegalArgumentException("Falsche Mehrlingsl\u00e4nge");
            }
            if (r > 0) {
                double augensumme = (double)(4 * (a + 4)) * this.augensumme(a, r - 1, 2) + 66.0 * Kombinatorik.augenzahl(r) - 2.0 * Kombinatorik.augenzahl(a, r - 1) + (double)(90 * a) + 21.0;
                int alpha = a + 1;
                while (alpha <= 6) {
                    augensumme += 4.0 * this.augensumme(alpha, r - 1, 2);
                    ++alpha;
                }
                return augensumme *= 0.013888888888888888;
            }
            return 0.0;
        }

        @Override
        protected boolean pasch() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }
    }

    protected class Eintragungen
    extends Analyse.Eintragungen {
        private static final long serialVersionUID = -7416744679857533889L;

        Eintragungen() {
            this.put(Kategorie.DREIERPASCH, new Dreierpasch());
            this.put(Kategorie.VIERERPASCH, new Viererpasch());
            this.put(Kategorie.FULLHOUSE, new FullHouse());
            this.put(Kategorie.KLEINESTRASSE, new KleineStrasse());
            this.put(Kategorie.GROSSESTRASSE, new GrosseStrasse());
            this.put(Kategorie.JAFUFFY, new JaFuffy());
        }
    }

    class FullHouse
    extends Analyse.Unten {
        private static final long serialVersionUID = -1069152277729232203L;
        static final int PUNKTE = 25;
        private final double[] restwahrscheinlichkeit = new double[]{0.03935185185185185, 0.23148148148148148, 0.1736111111111111, 0.46296296296296297, 0.0, 0.09259259259259259};
        private int fehlend;

        FullHouse() {
            this.startmittel = this.prognose(5, 3);
        }

        private boolean istFullHouse() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH) != false && (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }

        private double prognose(int k, int r) {
            return 25.0 * this.restwahrscheinlichkeit(k, r);
        }

        private double restwahrscheinlichkeit(int k, int r) {
            switch (k) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return 1.0 - Math.pow(0.6666666666666666, r);
                }
                case 2: {
                    return 1.0 - Math.pow(0.8333333333333334, r);
                }
                case 3: {
                    switch (r) {
                        case 1: {
                            return 0.09722222222222222;
                        }
                        case 2: {
                            return 0.27469135802469136;
                        }
                    }
                    return 0.0;
                }
                case 5: {
                    if (r == 0) {
                        return 0.0;
                    }
                    double p = 0.0;
                    int i = 0;
                    while (i <= 5) {
                        p += this.restwahrscheinlichkeit[i] * this.restwahrscheinlichkeit(i, r - 1);
                        ++i;
                    }
                    return p;
                }
            }
            return 0.0;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            return this.prognose(this.fehlend, spieler.rest());
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = this.istFullHouse() ? 25 : 0;
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            if (this.istFullHouse()) {
                this.fehlend = 0;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH)).booleanValue() || ((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH)).booleanValue()) {
                int zaehler = 0;
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfelsatz;
                int n = Klassisch.this.wuerfelsatz.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel wuerfel;
                    this.neuwurfkarte.put(wuerfel, (wuerfel = wuerfelArray[n2]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.DREIERPASCH.groesse() || zaehler == Analyse.Paschaufzaehlung.DREIERPASCH.groesse());
                    if (wuerfel.vorkommen(Klassisch.this.augenhaeufigkeiten) >= Analyse.Paschaufzaehlung.DREIERPASCH.groesse()) {
                        ++zaehler;
                    }
                    ++n2;
                }
                this.fehlend = 2;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH)).booleanValue()) {
                this.fehlend = 0;
                Object[] objectArray = Klassisch.this.augenhaeufigkeiten;
                int n = Klassisch.this.augenhaeufigkeiten.length;
                int n3 = 0;
                while (n3 < n) {
                    int haeufigkeit = objectArray[n3];
                    if (haeufigkeit == Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse()) {
                        this.fehlend = this.fehlend == 0 ? 3 : 1;
                    }
                    ++n3;
                }
                objectArray = Klassisch.this.wuerfelsatz;
                n = Klassisch.this.wuerfelsatz.length;
                n3 = 0;
                while (n3 < n) {
                    int wuerfel;
                    this.neuwurfkarte.put(wuerfel, (wuerfel = objectArray[n3]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse());
                    ++n3;
                }
            } else {
                this.nominiereNeuwurf(true);
                this.fehlend = 5;
            }
        }
    }

    public class GrosseStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 8292592862416663732L;
        public static final int PUNKTE = 40;
        private final int[] kandidat = new int[6];
        private int fehlend;

        GrosseStrasse() {
            this.startmittel = 40.0 * this.q(5, 3);
        }

        private double p(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int k = 0;
                while (k <= n) {
                    summe += this.u(n, k) * this.p(n - k, r - 1);
                    ++k;
                }
                return summe;
            }
            if (r == 1) {
                return (double)Kombinatorik.fakultaet(n) / Math.pow(6.0, n);
            }
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }

        private double q(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int k = 0;
                while (k <= n) {
                    summe += this.w(n, k) * this.q(n - k, r - 1) + this.v(n, k) * this.p(n - k, r - 1);
                    ++k;
                }
                return summe;
            }
            if (r == 1) {
                return (double)(2 * Kombinatorik.fakultaet(n)) / Math.pow(6.0, n);
            }
            return 0.0;
        }

        private double u(int n, int k) {
            return Kombinatorik.strassenteilsequenz(n, 6 - n, k, n) / Math.pow(6.0, n);
        }

        private double v(int n, int k) {
            return (double)(k * Kombinatorik.fallend(n - 1, k - 1) * (2 * Kombinatorik.strassenteilschablone(n, 5 - n, k) + (k + 1) * Kombinatorik.strassenteilschablone(n, 5 - n, k + 1))) / Math.pow(6.0, n);
        }

        private double w(int n, int k) {
            return Kombinatorik.strassenteilsequenz(n, 5 - n, k, n - 1) / Math.pow(6.0, n);
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            if (Klassisch.this.augenhaeufigkeiten[Strasse.Index.EINSER.ordinal()] > 0 || Klassisch.this.augenhaeufigkeiten[Strasse.Index.SECHSER.ordinal()] > 0) {
                return 40.0 * this.p(this.fehlend, spieler.rest());
            }
            return 40.0 * this.q(this.fehlend, spieler.rest());
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Strasse.Index.istGrosseStrasse(Klassisch.this.augenhaeufigkeiten) ? 40 : 0;
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            System.arraycopy(Klassisch.this.augenhaeufigkeiten, 0, this.kandidat, 0, 6);
            if (this.kandidat[Strasse.Index.EINSER.ordinal()] > 0 && this.kandidat[Strasse.Index.SECHSER.ordinal()] > 0) {
                if (ZUFALL.nextBoolean()) {
                    this.kandidat[Strasse.Index.EINSER.ordinal()] = 0;
                } else {
                    this.kandidat[Strasse.Index.SECHSER.ordinal()] = 0;
                }
            }
            this.fehlend = 0;
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfelsatz;
            int n = Klassisch.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel;
                int i = (wuerfel = wuerfelArray[n2]).augen() - 1;
                this.neuwurfkarte.put(wuerfel, this.kandidat[i] == 0);
                if (((Boolean)this.neuwurfkarte.get(wuerfel)).booleanValue()) {
                    ++this.fehlend;
                } else {
                    this.kandidat[i] = 0;
                }
                ++n2;
            }
        }
    }

    class JaFuffy
    extends Analyse.Unten {
        private static final long serialVersionUID = -6921954073317063844L;
        static final int PUNKTE = 50;

        JaFuffy() {
            this.startmittel = this.prognose(3, 0);
        }

        private double p(int r, int max) {
            if (r > 0) {
                double p = 0.0;
                if (max <= 1) {
                    int i = 1;
                    while (i <= 5) {
                        p += Kombinatorik.gleichenwahrscheinlichkeit(i) * this.p(r - 1, i);
                        ++i;
                    }
                } else {
                    p = max == 2 ? (80.0 * Kombinatorik.fixgleichenwahrscheinlichkeit(2, r - 1) + 15.0 * Kombinatorik.fixgleichenwahrscheinlichkeit(1, r - 1) + 1.0 + 120.0 * this.p(r - 1, 2)) / 216.0 : Kombinatorik.fixgleichenwahrscheinlichkeit(5 - max, r);
                }
                return p;
            }
            return max == 5 ? 1 : 0;
        }

        private double prognose(int r, int max) {
            return this.p(r, max) * 50.0;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            return this.prognose(spieler.rest(), this.paschlaenge());
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false ? 50 : 0;
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            int max = this.paschlaenge();
            ArrayList<Integer> augenauswahl = new ArrayList<Integer>();
            int ind = 0;
            while (ind < 6) {
                if (Klassisch.this.augenhaeufigkeiten[ind] == max) {
                    augenauswahl.add(ind + 1);
                }
                ++ind;
            }
            int augen = (Integer)augenauswahl.get(ZUFALL.nextInt(augenauswahl.size()));
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfelsatz;
            int n = Klassisch.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                this.neuwurfkarte.put(w, max == 1 || augen != w.augen());
                ++n2;
            }
        }
    }

    public class KleineStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 3736058022544823661L;
        private static final double P_TOT = 0.6025279;
        public static final int PUNKTE = 30;
        private int aussen;
        private int innen;
        private int mitte;

        KleineStrasse() {
            this.startmittel = 18.075837;
        }

        private void behalte(Strasse.Paar paar) {
            Strasse.Index[] indexArray = paar.feld();
            int n = indexArray.length;
            int n2 = 0;
            while (n2 < n) {
                Strasse.Index element = indexArray[n2];
                if (Klassisch.this.augenhaeufigkeiten[element.ordinal()] > 0) {
                    Wuerfel[] wuerfelArray = Klassisch.this.wuerfelsatz;
                    int n3 = Klassisch.this.wuerfelsatz.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Wuerfel w = wuerfelArray[n4];
                        if (w.augen() == element.augen()) {
                            this.neuwurfkarte.put(w, false);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Strasse.Index.istKleineStrasse(Klassisch.this.augenhaeufigkeiten) ? 30 : 0;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            if (Strasse.Index.istKleineStrasse(Klassisch.this.augenhaeufigkeiten)) {
                return 30.0;
            }
            if (spieler.rest() > 0) {
                return Strasse.KleinerIndex.TABELLE.get(new Strasse.KleinerIndex(this.aussen, this.innen, this.mitte, spieler.rest())).floatValue() * 30.0f;
            }
            return 0.0;
        }

        protected void waehleWuerfel(boolean fertig) {
            this.nominiereNeuwurf(!fertig);
            if (!fertig) {
                this.aussen = 0;
                this.innen = Strasse.Paar.INNEN.vorkommen(Klassisch.this.augenhaeufigkeiten);
                this.mitte = Strasse.Paar.MITTE.vorkommen(Klassisch.this.augenhaeufigkeiten);
                int links = Strasse.Paar.LINKS.vorkommen(Klassisch.this.augenhaeufigkeiten);
                int rechts = Strasse.Paar.RECHTS.vorkommen(Klassisch.this.augenhaeufigkeiten);
                if (this.innen == 2) {
                    this.behalte(Strasse.Paar.INNEN);
                } else if (this.innen == 1 && links <= 1 && rechts <= 1) {
                    this.behalte(Strasse.Paar.INNEN);
                } else if (links > rechts) {
                    this.aussen = links - this.innen;
                    this.behalte(Strasse.Paar.LINKS);
                } else if (links < rechts) {
                    this.aussen = rechts - this.innen;
                    this.behalte(Strasse.Paar.RECHTS);
                } else {
                    this.aussen = links - this.innen;
                    this.behalte(ZUFALL.nextBoolean() ? Strasse.Paar.LINKS : Strasse.Paar.RECHTS);
                }
                this.behalte(Strasse.Paar.MITTE);
            }
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            this.waehleWuerfel(false);
        }
    }

    class Viererpasch
    extends Analyse.Pasch {
        private static final long serialVersionUID = -3378721831288162486L;
        private static final int PASCHGROESSE = 4;

        Viererpasch() {
            super(4);
        }

        @Override
        protected double augensumme(int a, int r, int k) {
            switch (k) {
                case 2: {
                    return this.augensumme2(a, r);
                }
                case 3: {
                    return this.augensumme3(a, r);
                }
            }
            throw new IllegalArgumentException("Falsche Mehrlingsl\u00e4nge");
        }

        protected double augensumme2(int a, int r) {
            if (r > 0) {
                double augensumme = (double)(48 + 12 * a) * this.augensumme2(a, r - 1) + 75.0 * this.augensumme3(a, r - 1) + 18.0 * Kombinatorik.augenzahl(r) - 2.0 * Kombinatorik.augenzahl(a, r - 1) + (double)(64 * a);
                int alpha = 0;
                while (alpha < a) {
                    augensumme += this.augensumme3(alpha, r - 1);
                    ++alpha;
                }
                alpha = a + 1;
                while (alpha <= 6) {
                    augensumme += 12.0 * this.augensumme2(alpha, r - 1);
                    augensumme += this.augensumme3(alpha, r - 1);
                    ++alpha;
                }
                return augensumme /= 216.0;
            }
            return 0.0;
        }

        protected double augensumme3(int a, int r) {
            if (r > 0) {
                double augensumme = 25.0 * this.augensumme3(a, r - 1) + (double)(44 * a) + 12.0 * Kombinatorik.augenzahl(r) - Kombinatorik.augenzahl(a, r - 1);
                return augensumme /= 36.0;
            }
            return 0.0;
        }

        @Override
        protected boolean pasch() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }
    }
}

