/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Kategorie;
import jafuffy.logik.Spieler;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Kombinatorik;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;

public abstract class Analyse
implements Serializable {
    private static final long serialVersionUID = -6325984568972413728L;
    public static final int BONUSGRENZE = 63;
    public static final int BONUS = 35;
    private static final double NEUTRALWICHTUNG = 1.0;
    protected static final Random ZUFALL = new Random();
    private final Eintragungen eintragungen;
    private Kategorie optimalzeile;
    protected final int[] augenhaeufigkeiten = new int[6];
    protected final Map<Paschaufzaehlung, Boolean> paschkarte = new HashMap<Paschaufzaehlung, Boolean>(Paschaufzaehlung.values().length, 1.0f);
    protected final Wuerfel[] wuerfelsatz;
    protected int augensumme;

    protected Analyse(Wuerfel[] wuerfelsatz) {
        this.wuerfelsatz = wuerfelsatz;
        this.eintragungen = this.eintragungen();
    }

    public Kategorie bester() {
        return this.optimalzeile;
    }

    public void bewerte(Kategorie kategorie, Spieler spieler) {
        this.eintrag(kategorie).bewerte(spieler);
    }

    public boolean erneut(Kategorie kategorie, Wuerfel wuerfel) {
        return this.eintrag(kategorie).erneut(wuerfel);
    }

    public void errechne(Spieler spieler) {
        int n;
        int n2;
        Object[] objectArray;
        Arrays.fill(this.augenhaeufigkeiten, 0);
        this.augensumme = 0;
        if (spieler.gewuerfelt()) {
            objectArray = this.wuerfelsatz;
            n2 = this.wuerfelsatz.length;
            n = 0;
            while (n < n2) {
                Paschaufzaehlung wuerfel = objectArray[n];
                this.augensumme += ((Wuerfel)((Object)wuerfel)).augen();
                int n3 = ((Wuerfel)((Object)wuerfel)).augen() - 1;
                this.augenhaeufigkeiten[n3] = this.augenhaeufigkeiten[n3] + 1;
                ++n;
            }
        }
        objectArray = Paschaufzaehlung.values();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Paschaufzaehlung pasch = objectArray[n];
            boolean istPaschVorhanden = false;
            int[] nArray = this.augenhaeufigkeiten;
            int n4 = this.augenhaeufigkeiten.length;
            int n5 = 0;
            while (n5 < n4) {
                int augenhaeufigkeit = nArray[n5];
                istPaschVorhanden = augenhaeufigkeit == pasch.groesse() || istPaschVorhanden;
                ++n5;
            }
            this.paschkarte.put(pasch, istPaschVorhanden);
            ++n;
        }
        objectArray = Kategorie.SETZBAR;
        n2 = Kategorie.SETZBAR.length;
        n = 0;
        while (n < n2) {
            Paschaufzaehlung kategorie = objectArray[n];
            this.bewerte((Kategorie)((Object)kategorie), spieler);
            ++n;
        }
        this.bewerte(Kategorie.BONUS, spieler);
    }

    public boolean istVorschlagEntsprechendWuerfelauswahl(Kategorie kategorie) {
        int[] anzahlenJeAugenAusgewaehlte = new int[6];
        int[] anzahlenJeAugenVorgeschlagene = new int[6];
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            int a = wuerfel.augen() - 1;
            if (wuerfel.darstellungsmodell().isSelected()) {
                int n3 = a;
                anzahlenJeAugenAusgewaehlte[n3] = anzahlenJeAugenAusgewaehlte[n3] + 1;
            }
            if (this.eintrag(kategorie).erneut(wuerfel)) {
                int n4 = a;
                anzahlenJeAugenVorgeschlagene[n4] = anzahlenJeAugenVorgeschlagene[n4] + 1;
            }
            ++n2;
        }
        int a = 0;
        while (a < 6) {
            if (anzahlenJeAugenAusgewaehlte[a] != anzahlenJeAugenVorgeschlagene[a]) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public void prognostiziere(Spieler spieler) {
        this.eintrag(Kategorie.BONUS).tippe(spieler);
        Kategorie[] kategorieArray = Kategorie.SETZBAR;
        int n = Kategorie.SETZBAR.length;
        int n2 = 0;
        while (n2 < n) {
            Kategorie kategorie = kategorieArray[n2];
            if (spieler.setzbar(kategorie)) {
                this.eintrag(kategorie).tippe(spieler);
            }
            ++n2;
        }
        this.gewichte(spieler, this.findeMinimum(spieler), this.findeMaximum(spieler));
    }

    public final int wert(Kategorie kategorie) {
        return this.eintrag(kategorie).wert();
    }

    public double wichtung(Kategorie kategorie) {
        return this.eintrag(kategorie).wichtung();
    }

    private Eintrag eintrag(Kategorie kategorie) {
        return (Eintrag)this.eintragungen.get((Object)kategorie);
    }

    private double findeMaximum(Spieler spieler) {
        double max = Double.NEGATIVE_INFINITY;
        this.optimalzeile = null;
        Kategorie[] kategorieArray = Kategorie.SETZBAR;
        int n = Kategorie.SETZBAR.length;
        int n2 = 0;
        while (n2 < n) {
            double zuwachsmittel;
            Kategorie kategorie = kategorieArray[n2];
            if (spieler.setzbar(kategorie) && (zuwachsmittel = this.eintrag(kategorie).zuwachsmittel()) > max) {
                this.optimalzeile = kategorie;
                max = zuwachsmittel;
            }
            ++n2;
        }
        return max;
    }

    private double findeMinimum(Spieler spieler) {
        double min = Double.POSITIVE_INFINITY;
        Kategorie[] kategorieArray = Kategorie.SETZBAR;
        int n = Kategorie.SETZBAR.length;
        int n2 = 0;
        while (n2 < n) {
            double zuwachsmittel;
            Kategorie kategorie = kategorieArray[n2];
            if (spieler.setzbar(kategorie) && (zuwachsmittel = this.eintrag(kategorie).zuwachsmittel()) < min) {
                min = zuwachsmittel;
            }
            ++n2;
        }
        return min;
    }

    private void gewichte(Spieler spieler, double min, double max) {
        Kategorie[] kategorieArray = Kategorie.SETZBAR;
        int n = Kategorie.SETZBAR.length;
        int n2 = 0;
        while (n2 < n) {
            Kategorie kategorie = kategorieArray[n2];
            if (spieler.setzbar(kategorie)) {
                if (max - min > 0.0) {
                    double zuwachsmittel = this.eintrag(kategorie).zuwachsmittel();
                    this.eintrag(kategorie).gewichte((zuwachsmittel - min) / (max - min));
                } else {
                    this.eintrag(kategorie).gewichte(1.0);
                }
            } else {
                this.eintrag(kategorie).gewichte(0.0);
            }
            ++n2;
        }
    }

    protected abstract Eintragungen eintragungen();

    protected class Bonus
    extends Eintrag {
        private static final long serialVersionUID = -3335885336754745784L;
        private int f;
        private int kumulation;

        Bonus() {
            this.f = Kategorie.OBEN.length;
            this.kumulation = this.f * (this.f + 1) / 2;
        }

        private double mehrlingskumulationsprognose(double gesamtsumme, int frei, int kumulationssumme) {
            if (gesamtsumme < 63.0) {
                if (kumulationssumme > 0) {
                    int m = (int)Math.ceil((63.0 - gesamtsumme) / (double)kumulationssumme * (double)frei);
                    return Kombinatorik.mehrlingskumulationswahrscheinlichkeit(frei, m) * 35.0f;
                }
                return 0.0;
            }
            return 35.0;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = spieler.gesamt() >= 63 ? 35 : 0;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            return this.startmittel;
        }

        @Override
        protected void tippe(Spieler spieler) {
            this.f = 0;
            this.kumulation = 0;
            Kategorie[] kategorieArray = Kategorie.OBEN;
            int n = Kategorie.OBEN.length;
            int n2 = 0;
            while (n2 < n) {
                Kategorie kategorie = kategorieArray[n2];
                if (spieler.setzbar(kategorie)) {
                    ++this.f;
                    Oben oben = (Oben)Analyse.this.eintrag(kategorie);
                    this.kumulation += oben.augen;
                }
                ++n2;
            }
            this.startmittel = this.mehrlingskumulationsprognose(spieler.gesamt(), this.f, this.kumulation);
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
        }

        double mehrlingskumulationsprognose(double gesamtsumme, int augenzahl) {
            return this.mehrlingskumulationsprognose(gesamtsumme, this.f - 1, this.kumulation - augenzahl);
        }
    }

    class Chance
    extends Unten {
        private static final long serialVersionUID = -3411668587180538841L;
        private double punkte;

        Chance() {
            this.startmittel = 5.0 * Kombinatorik.augenzahl(3);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Analyse.this.augensumme;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            this.punkte = 0.0;
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel = wuerfelArray[n2];
                this.punkte += Kombinatorik.augenzahl(wuerfel.augen(), spieler.rest());
                ++n2;
            }
            return this.punkte;
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel;
                this.neuwurfkarte.put(wuerfel, Kombinatorik.augenzahl((wuerfel = wuerfelArray[n2]).augen(), spieler.rest()) > (double)wuerfel.augen());
                ++n2;
            }
        }
    }

    protected abstract class Eintrag
    implements Serializable {
        private static final long serialVersionUID = -1491939796847928172L;
        private double wichtung;
        protected final IdentityHashMap<Wuerfel, Boolean> neuwurfkarte = new IdentityHashMap(5);
        protected int wert;
        protected double zuwachsmittel;
        protected double startmittel;

        protected Eintrag() {
            this.nominiereNeuwurf(true);
        }

        private double unsicherheit(double mittel, double delta) {
            return mittel * (1.0 + delta * (2.0 * ZUFALL.nextDouble() - 1.0));
        }

        protected abstract void bewerte(Spieler var1);

        protected void nominiereNeuwurf(boolean istNeuwurf) {
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel = wuerfelArray[n2];
                this.neuwurfkarte.put(wuerfel, istNeuwurf);
                ++n2;
            }
        }

        protected abstract double ergebnismittel(Spieler var1);

        protected void tippe(Spieler spieler) {
            this.waehleWuerfel(spieler);
            double delta = spieler.unsicherheit();
            this.zuwachsmittel = this.unsicherheit(this.ergebnismittel(spieler), delta) - this.unsicherheit(this.startmittel(), delta);
        }

        protected void waehleWuerfel(Spieler spieler) {
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel = wuerfelArray[n2];
                this.neuwurfkarte.put(wuerfel, spieler.rest() == 0);
                ++n2;
            }
        }

        double zuwachsmittel() {
            return this.zuwachsmittel;
        }

        boolean erneut(Wuerfel wuerfel) {
            return this.neuwurfkarte.get(wuerfel);
        }

        void gewichte(double wichtung) {
            this.wichtung = wichtung;
        }

        double startmittel() {
            return this.startmittel;
        }

        int wert() {
            return this.wert;
        }

        double wichtung() {
            return this.wichtung;
        }
    }

    protected abstract class Eintragungen
    extends HashMap<Kategorie, Eintrag> {
        private static final long serialVersionUID = 8130365096301351531L;

        protected Eintragungen() {
            super(Kategorie.SETZBAR.length, 1.0f);
            Bonus bonus = new Bonus();
            int index = 0;
            while (index < Kategorie.OBEN.length) {
                this.put(Kategorie.oben(index + 1), new Oben(index, bonus));
                ++index;
            }
            this.put(Kategorie.BONUS, bonus);
            this.put(Kategorie.CHANCE, new Chance());
        }
    }

    protected class Oben
    extends Eintrag {
        private static final long serialVersionUID = -5829769579272736329L;
        private final int augen;
        private final int index;
        private final Bonus bonus;

        Oben(int strassenindex, Bonus bonus) {
            this.index = strassenindex;
            this.bonus = bonus;
            this.augen = strassenindex + 1;
            this.startmittel = (double)this.augen * Kombinatorik.fixgleichenmittel(5, 3);
        }

        private double ergebnismittel(int haeufigkeit, int r, int gesamt) {
            double minimum;
            double punkte = minimum = (double)(this.augen * haeufigkeit);
            int n = 5 - haeufigkeit;
            int k = 0;
            while (k <= n) {
                double p = Kombinatorik.fixgleichenwahrscheinlichkeit(n, k, r);
                double beitrag = k * this.augen;
                beitrag += this.bonus.mehrlingskumulationsprognose((double)gesamt + minimum + beitrag, this.augen);
                punkte += p * beitrag;
                ++k;
            }
            return punkte;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Analyse.this.augenhaeufigkeiten[this.index] * this.augen;
        }

        @Override
        protected double ergebnismittel(Spieler spieler) {
            return this.ergebnismittel(Analyse.this.augenhaeufigkeiten[this.index], spieler.rest(), spieler.gesamt());
        }

        @Override
        protected void tippe(Spieler spieler) {
            this.startmittel = this.ergebnismittel(0, 3, spieler.gesamt());
            super.tippe(spieler);
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel;
                this.neuwurfkarte.put(wuerfel, (wuerfel = wuerfelArray[n2]).augen() != this.augen);
                ++n2;
            }
        }
    }

    protected abstract class Pasch
    extends Unten {
        private static final long serialVersionUID = 8666151619656864766L;
        private final int paschgroesse;
        private int paschaugenzahl;

        protected Pasch(int paschgroesse) {
            this.paschgroesse = paschgroesse;
            this.startmittel = this.augensumme(3);
        }

        private double augensumme(int r) {
            if (r > 0) {
                double augensumme = Kombinatorik.gleichenwahrscheinlichkeit(1) * this.augensumme(r - 1);
                int k = 2;
                while (k < this.paschgroesse) {
                    int a = 1;
                    while (a <= 6) {
                        augensumme += Kombinatorik.mehrlingswahrscheinlichkeit(a, k) * this.augensumme(a, r - 1, k);
                        ++a;
                    }
                    ++k;
                }
                return augensumme += (3.5 * (double)this.paschgroesse + (double)(5 - this.paschgroesse) * Kombinatorik.augenzahl(r)) * Kombinatorik.mindestgleichenwahrscheinlichkeit(this.paschgroesse);
            }
            return 0.0;
        }

        private double prognose(int augen, int r, int max) {
            double punkte = 0.0;
            if (max < this.paschgroesse) {
                punkte = max > 1 ? this.augensumme(augen, r, max) : this.augensumme(r);
            } else {
                Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
                int n = Analyse.this.wuerfelsatz.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel wuerfel = wuerfelArray[n2];
                    punkte = ((Boolean)this.neuwurfkarte.get(wuerfel)).booleanValue() ? (punkte += Kombinatorik.augenzahl(r)) : (punkte += (double)wuerfel.augen());
                    ++n2;
                }
            }
            return punkte;
        }

        protected abstract double augensumme(int var1, int var2, int var3);

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = this.pasch() ? Analyse.this.augensumme : 0;
        }

        protected abstract boolean pasch();

        @Override
        protected double ergebnismittel(Spieler spieler) {
            return this.prognose(this.paschaugenzahl, spieler.rest(), this.paschlaenge());
        }

        @Override
        protected void waehleWuerfel(Spieler spieler) {
            super.waehleWuerfel(spieler);
            this.paschaugenzahl = 6;
            while (Analyse.this.augenhaeufigkeiten[this.paschaugenzahl - 1] < this.paschlaenge()) {
                --this.paschaugenzahl;
            }
            int haeufigkeit = 0;
            Wuerfel[] wuerfelArray = Analyse.this.wuerfelsatz;
            int n = Analyse.this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel wuerfel = wuerfelArray[n2];
                if (wuerfel.augen() == this.paschaugenzahl) {
                    this.neuwurfkarte.put(wuerfel, ++haeufigkeit > this.paschgroesse && Kombinatorik.augenzahl(spieler.rest()) > (double)wuerfel.augen());
                } else {
                    this.neuwurfkarte.put(wuerfel, !this.pasch() || Kombinatorik.augenzahl(spieler.rest()) > (double)wuerfel.augen());
                }
                ++n2;
            }
        }
    }

    protected static enum Paschaufzaehlung {
        ZWEIERPASCH,
        DREIERPASCH,
        VIERERPASCH,
        FUENFERPASCH;


        public int groesse() {
            return this.ordinal() + 2;
        }
    }

    protected abstract class Unten
    extends Eintrag {
        private static final long serialVersionUID = 8894740065051562154L;

        protected Unten() {
        }

        protected int paschlaenge() {
            int max = 1;
            for (Map.Entry<Paschaufzaehlung, Boolean> pasch : Analyse.this.paschkarte.entrySet()) {
                int groesse = pasch.getKey().groesse();
                boolean istPaschVorhanden = pasch.getValue();
                if (!istPaschVorhanden || groesse <= max) continue;
                max = groesse;
            }
            return max;
        }
    }
}

