/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import jafuffy.logik.ereignis.Wuerfelstand;
import jafuffy.netzwerk.Vermittlung;
import jafuffy.netzwerk.ereignis.Wuerfelabwahl;
import jafuffy.netzwerk.ereignis.Wuerfelanwahl;
import jafuffy.netzwerk.ereignis.Wurfdarlegung;
import jafuffy.netzwerk.ereignis.Wurfergebnis;
import jafuffy.netzwerk.ereignis.Wurfsetzung;
import java.awt.event.ActionEvent;
import java.net.SocketException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Aufsicht
implements Vermittlung.Stoerung,
ChangeListener {
    private static final int AKTIONSDAUER_DEUTLICH = 400;
    private static final int AKTIONSDAUER_SCHNELL = 200;
    private static boolean optimiert;
    public static final String ANSTEHENDE_AKTION = "Anstehende Aktion";
    public static final String ALLE_AKTIONEN = "Alle Aktionen";
    private final Action alleAktionen = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.alles = true;
            Aufsicht.this.schritt.mache(event);
        }
    };
    private final Action naechsteAktion = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.schritt.mache(event);
        }
    };
    private final Eigenschaften eigenschaften;
    private final Fenster fenster;
    private final Becher becher;
    private final Vorschlagen vorschlagen;
    private final Setzen setzen;
    private final Verfolgung verfolgung;
    private final Ueberlegungsaktion ueberlegungsaktion = new Ueberlegungsaktion();
    private final Wurfaktion wurfaktion = new Wurfaktion();
    private final Setzaktion setzaktion = new Setzaktion();
    private boolean nichtverteilend;
    private int bereitgestellt = 0;
    private final ChangeListener[] wuerfelsatzbeobachter = new ChangeListener[5];
    private Vermittlung vermittlung;
    private volatile Turnier turnier;
    private Schritt schritt;
    private boolean alles;

    public static void simuliere() {
        optimiert = true;
    }

    Aufsicht(Eigenschaften eigenschaften, Fenster fenster, Vorschlagen vorschlagen, Becher becher, Verfolgung verfolgung, Setzen setzen) {
        int w = 0;
        while (w < this.wuerfelsatzbeobachter.length) {
            int index = w++;
            this.wuerfelsatzbeobachter[index] = anderungsereignis -> {
                Umschlag umschlag = Umschlag.ereignisbehaelter(anderungsereignis);
                Wuerfel wuerfel = (Wuerfel)umschlag.quelle();
                Wuerfelstand ereignis = (Wuerfelstand)((Object)((Object)umschlag.ereignis()));
                try {
                    this.folgeWuerfel(index, wuerfel, ereignis);
                }
                catch (Exception ausnahme) {
                    this.abbreche(ausnahme);
                }
            };
        }
        this.eigenschaften = eigenschaften;
        this.fenster = fenster;
        this.vorschlagen = vorschlagen;
        this.becher = becher;
        this.setzen = setzen;
        this.verfolgung = verfolgung;
        verfolgung.verknuepfe(this.alleAktionen, ALLE_AKTIONEN, "<html>Bot soll alle seine anstehenden Aktionen abschlie\u00dfen und dann die W\u00fcrfel abgeben.<br><small>Mausklick oder Taste \"Ende\"</small></html>");
        verfolgung.verknuepfe(this.naechsteAktion, ANSTEHENDE_AKTION, "<html>Bot soll nur mit seiner n\u00e4chsten anstehenden Aktion weitermachen.<br><small>Mausklick oder Taste \"Bild ab\"</small></html>");
    }

    @Override
    public synchronized void abbreche(Exception ausnahme) {
        ausnahme.printStackTrace();
        if (this.turnier != null) {
            Turnier ueberbleibsel = this.turnier;
            SwingUtilities.invokeLater(() -> {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.fenster, "St\u00f6rung im Turnierbetrieb \u00fcber Netzwerk.\nTurnier muss abgebrochen werden.\n\nJava-Exception:\n" + ausnahme.getLocalizedMessage(), "JaFuffy (Fehler)", 0));
                ueberbleibsel.beende();
            });
        }
        this.turnier = null;
    }

    @Override
    public void stateChanged(ChangeEvent aenderungsereignis) {
        if (Umschlag.adressiert(aenderungsereignis, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(aenderungsereignis);
            Ablauf ereignis = (Ablauf)((Object)umschlag.ereignis());
            switch (ereignis) {
                case START: {
                    this.turnier = (Turnier)umschlag.quelle();
                    this.alleAktionen.setEnabled(true);
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.turnier = null;
                }
            }
            if (this.turnier != null) {
                if (this.turnier.aktiver().real()) {
                    this.folgeSpieler(ereignis);
                } else {
                    this.folgeBot(ereignis);
                }
            }
        }
    }

    public void verknuepfe(Vermittlung vermittlung) {
        this.vermittlung = vermittlung;
    }

    private int aktionsdauer() {
        int dauer = optimiert ? 0 : (this.eigenschaften.aktiv("Kurzdarstellung") ? 200 : 400);
        if (this.alles) {
            dauer *= 2;
        }
        return dauer;
    }

    private boolean autonom() {
        return this.eigenschaften.aktiv("Geisterhand");
    }

    private void erledige(boolean zulaessig) {
        if (zulaessig) {
            SwingUtilities.invokeLater(() -> this.verfolgung.erledigeNaechsteAktion(this.aktionsdauer()));
        }
    }

    private void folgeBot(Ablauf ereignis) {
        switch (ereignis) {
            case START: 
            case SPIEL: {
                this.registriere(this.ueberlegungsaktion);
                this.erledige(this.alles || this.autonom());
                break;
            }
            case GEWORFEN: {
                this.registriere(this.ueberlegungsaktion);
                this.erledige(this.alles || this.knapper());
                break;
            }
            case FERTIG: {
                this.registriere(this.wurfaktion);
                this.erledige(this.autonom());
                break;
            }
        }
    }

    private void folgeSpieler(Ablauf ereignis) {
        if (this.vermittlung == null) {
            return;
        }
        try {
            switch (ereignis) {
                case START: {
                    this.nichtverteilend = this.turnier.aktiver().stellvertretend();
                    break;
                }
                case GEWORFEN: {
                    this.nichtverteilend = this.turnier.aktiver().stellvertretend();
                    if (this.nichtverteilend) {
                        return;
                    }
                    this.vermittlung.verteile(new Wurfdarlegung());
                    break;
                }
                case FERTIG: 
                case RESULTAT: {
                    this.bereitgestellt = this.wuerfelsatzbeobachter.length;
                    this.nichtverteilend = this.turnier.aktivermerker().stellvertretend();
                    if (this.nichtverteilend) {
                        return;
                    }
                    this.vermittlung.verteile(new Wurfsetzung(this.turnier.kategoriemerker()));
                    this.nichtverteilend = this.turnier.aktiver().stellvertretend();
                    break;
                }
                case SPIEL: {
                    this.bereitgestellt = this.wuerfelsatzbeobachter.length;
                    this.nichtverteilend = this.turnier.aktiver().stellvertretend();
                    break;
                }
                default: {
                    this.nichtverteilend = true;
                    break;
                }
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception ausnahme) {
            this.abbreche(ausnahme);
        }
    }

    private void folgeWuerfel(int index, Wuerfel wuerfel, Wuerfelstand ereignis) throws Exception {
        if (this.vermittlung == null || this.nichtverteilend()) {
            return;
        }
        switch (ereignis) {
            case ABWAHL: {
                this.vermittlung.verteile(new Wuerfelabwahl(index));
                break;
            }
            case ANWAHL: {
                this.vermittlung.verteile(new Wuerfelanwahl(index));
                break;
            }
            case WURF: {
                this.vermittlung.verteile(new Wurfergebnis(index, wuerfel.augen()));
            }
        }
    }

    private boolean knapper() {
        return !this.eigenschaften.aktiv("Ueberlegungsbestaetigung");
    }

    private boolean nichtverteilend() {
        boolean nichtverteilend = this.nichtverteilend;
        if (this.bereitgestellt > 0) {
            --this.bereitgestellt;
            if (this.bereitgestellt == 0) {
                this.nichtverteilend = this.turnier.aktiver().stellvertretend();
            }
        }
        return nichtverteilend;
    }

    private void registriere(Schritt schritt) {
        this.schritt = schritt;
        this.naechsteAktion.putValue("LongDescription", String.valueOf(this.turnier.aktiver().anzeigename()) + schritt.toString());
    }

    private boolean wuerfelbereit() {
        Wuerfel[] wuerfelArray = this.turnier.wuerfelsatz();
        int n = wuerfelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            if (wuerfel.darstellungsmodell().isSelected()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ChangeListener wuerfelbeobachter(int index) {
        return this.wuerfelsatzbeobachter[index];
    }

    private static interface Schritt {
        public void mache(ActionEvent var1);
    }

    private class Setzaktion
    implements Schritt {
        private Setzaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.alles = false;
            Aufsicht.this.setzen.doClick();
            Aufsicht.this.alleAktionen.setEnabled(true);
        }

        public String toString() {
            return " m\u00f6chte jetzt setzen.";
        }
    }

    private class Ueberlegungsaktion
    implements Schritt {
        private Ueberlegungsaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.vorschlagen.doClick();
            if (Aufsicht.this.wuerfelbereit()) {
                Aufsicht.this.registriere(Aufsicht.this.wurfaktion);
            } else {
                Aufsicht.this.registriere(Aufsicht.this.setzaktion);
            }
            Aufsicht.this.erledige(Aufsicht.this.alles || Aufsicht.this.autonom());
        }

        public String toString() {
            return Aufsicht.this.knapper() ? " \u00fcberlegt jetzt." : " m\u00f6chte jetzt \u00fcberlegen.";
        }
    }

    private class Wurfaktion
    implements Schritt {
        private Wurfaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.alleAktionen.setEnabled(false);
            Aufsicht.this.becher.doClick();
        }

        public String toString() {
            return Aufsicht.this.knapper() ? " m\u00f6chte jetzt w\u00fcrfeln und \u00fcberlegen." : " m\u00f6chte jetzt w\u00fcrfeln.";
        }
    }
}

