/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Status;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Wechselfeld;
import jafuffy.bedienung.Wuerfelreihe;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wuerfelfeld
extends JPanel
implements ChangeListener {
    private final Aktion aktion;
    private final Wuerfelreihe wuerfelreihe = new Wuerfelreihe();
    private final Wechselfeld wechselfeld = new Wechselfeld(this.wuerfelreihe);
    private final Kontextmenue kontextmenue = new Kontextmenue();
    private final Status status;

    Wuerfelfeld(Becher becher, Verfolgung verfolgung) {
        this.setLayout(new BoxLayout(this, 1));
        this.aktion = new Aktion(becher);
        this.status = new Status(this.kontextmenue, verfolgung);
        this.add(this.aktion);
        this.add(this.wechselfeld);
        this.add(this.status);
        this.wechselfeld.addMouseListener(this.kontextmenue);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: {
                    this.aktion.starte((Turnier)umschlag.quelle());
                }
                case SPIEL: 
                case FERTIG: {
                    this.aktion.informiere(((Turnier)umschlag.quelle()).maximalanzahl(), ((Turnier)umschlag.quelle()).spielnummer());
                }
                case GEWORFEN: 
                case RUECKGAENGIG: {
                    this.aktualisiere(((Turnier)umschlag.quelle()).aktiver());
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.aktion.beende((Turnier)umschlag.quelle());
                    break;
                }
            }
        }
        this.wuerfelreihe.stateChanged(ce);
        this.wechselfeld.stateChanged(ce);
        this.status.stateChanged(ce);
        this.aktion.becher.stateChanged(ce);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.kontextmenue != null) {
            SwingUtilities.updateComponentTreeUI(this.kontextmenue.auswahlkontext);
            this.kontextmenue.auswahlkontext.pack();
        }
    }

    private void aktualisiere(Spieler aktiver) {
        boolean neu = aktiver.neu();
        boolean fertig = aktiver.fertig();
        this.kontextmenue.invertieren.setEnabled(!fertig && !neu);
        this.kontextmenue.wuerfeln.setEnabled(!fertig && !neu);
    }

    private static class Aktion
    extends JPanel {
        private static final int CLICK = 100;
        private static final int GROESSE = 14;
        private static final int MINDESTABSTAND = 8;
        private final Becher becher;
        private final JLabel titel = new JLabel("Turnier");

        Aktion(Becher becher) {
            super(new BorderLayout());
            this.becher = becher;
            this.dekoriere();
            this.add((Component)this.baue(), "Center");
            this.setBorder(new EmptyBorder(0, 0, 8, 0));
        }

        private JPanel baue() {
            JPanel elemente = new JPanel();
            elemente.setLayout(new BoxLayout(elemente, 1));
            elemente.add(Box.createVerticalGlue());
            elemente.add(this.titel);
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(Box.createVerticalGlue());
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(this.becher);
            elemente.add(Box.createVerticalGlue());
            return elemente;
        }

        private void dekoriere() {
            this.titel.setFont(new Font("Dialog", 1, 14));
            this.titel.setAlignmentX(0.5f);
            this.titel.setHorizontalAlignment(0);
            this.becher.setActionCommand("Gewuerfelt");
        }

        void beende(Turnier turnier) {
            this.titel.setText("Turnierende");
            this.becher.removeActionListener(turnier);
        }

        void informiere(int anzahl, int nummer) {
            switch (anzahl) {
                case 0: {
                    this.titel.setText(String.valueOf(nummer) + ". Spiel im Turnier");
                    break;
                }
                case 1: {
                    this.titel.setText("Einziges Spiel im Turnier");
                    break;
                }
                default: {
                    this.titel.setText(String.valueOf(nummer) + ". von " + anzahl + " Spielen im Turnier");
                }
            }
        }

        void klicke() {
            this.becher.doClick(100);
        }

        void starte(Turnier turnier) {
            this.becher.addActionListener(turnier);
        }
    }

    class Kontextmenue
    extends MouseAdapter {
        private final JPopupMenu auswahlkontext = new JPopupMenu();
        private final JMenuItem aufheben = new JMenuItem("Auswahl aufheben");
        private final JMenuItem invertieren = new JMenuItem("Auswahl umkehren");
        private final JMenuItem sortieren = new JMenuItem("Sortieren");
        private final JMenuItem wuerfeln = new JMenuItem("Alle W\u00fcrfel werfen");

        Kontextmenue() {
            this.dekoriere();
            this.verbinde();
            this.baue();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && Wuerfelfeld.this.wechselfeld.isEnabled()) {
                Wuerfelfeld.this.wuerfelreihe.sortiere();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && Wuerfelfeld.this.wechselfeld.isEnabled()) {
                this.sortieren.setEnabled(!Wuerfelfeld.this.wuerfelreihe.sortiert());
                this.aufheben.setEnabled(Wuerfelfeld.this.wuerfelreihe.selektiert());
                this.auswahlkontext.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void baue() {
            this.auswahlkontext.add(this.sortieren);
            this.auswahlkontext.add(this.aufheben);
            this.auswahlkontext.add(this.invertieren);
            this.auswahlkontext.addSeparator();
            this.auswahlkontext.add(this.wuerfeln);
        }

        private void dekoriere() {
            this.sortieren.setToolTipText("Der Gr\u00f6\u00dfe nach sortieren");
            this.aufheben.setToolTipText("Alle W\u00fcrfel aus dem Becher");
            this.invertieren.setToolTipText("Auswahl umkehren (alle anklicken)");
            this.wuerfeln.setToolTipText("Alle W\u00fcrfel in den Becher und w\u00fcrfeln");
        }

        private void verbinde() {
            this.sortieren.addActionListener(ereignis -> Wuerfelfeld.this.wuerfelreihe.sortiere());
            this.aufheben.addActionListener(ereignis -> Wuerfelfeld.this.wuerfelreihe.klicke(true));
            this.invertieren.addActionListener(ereignis -> Wuerfelfeld.this.wuerfelreihe.invertiere());
            this.wuerfeln.addActionListener(ereignis -> {
                Wuerfelfeld.this.wuerfelreihe.klicke(false);
                Wuerfelfeld.this.aktion.klicke();
            });
        }
    }
}

