/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Signal;
import jafuffy.logik.Statistik;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Ende
extends WindowAdapter
implements ChangeListener {
    private final Eigenschaften eigenschaften;
    private final Statistik statistik;
    private Turnier turnier;

    public Ende(Eigenschaften eigenschaften, Statistik statistik) {
        this.eigenschaften = eigenschaften;
        this.statistik = statistik;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: {
                    this.turnier = (Turnier)umschlag.quelle();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.turnier = null;
                }
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent we) {
        Window fenster = we.getWindow();
        if (Eigenschaften.GLOBAL.neustart() || JOptionPane.showConfirmDialog(fenster, "JaFuffy beenden?", "JaFuffy (Frage)", 0) == 0) {
            this.sichereTurnierEigenschaften(fenster);
            this.sichereStatistik(fenster);
            this.beendeApplikation();
        }
    }

    private void beendeApplikation() {
        if (this.turnier != null) {
            this.turnier.beende();
        }
        System.exit(0);
    }

    private void sichereStatistik(Window fenster) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.eigenschaften.datei("Statistik.obj")));
            out.writeObject(this.statistik);
            out.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "Statistik konnte nicht gesichert werden!\nJava-Exception:\n" + exception, "JaFuffy (Fehler)", 0);
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen erlauben keine persistente Speicherung der Statistik: " + exception);
        }
    }

    private void sichereTurnierEigenschaften(Window fenster) {
        try {
            this.eigenschaften.speichere(fenster.getX(), fenster.getY(), fenster.getWidth(), fenster.getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "JaFuffy-Einstellungen konnten nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }
}

