/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Geraeusch;
import jafuffy.bedienung.Grafik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import jafuffy.logik.ereignis.Wuerfelstand;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Becher
extends JButton
implements ChangeListener {
    private static final ImageIcon[] BECHER = new ImageIcon[6];
    private static final Geraeusch[] WUERFELN;
    private static final Geraeusch SCHUETTELN;
    private static final int DELAY = 75;
    private static final String WERFEN = "<html>W\u00fcrfel im Becher werfen<br><small>Mausklick oder Taste \"w\"</small></html>";
    private static final String LEGEN = "Bitte W\u00fcrfel in Becher legen";
    private static final String SETZEN = "Bitte in der Tabelle setzen";
    private static final String VERTRETUNG = "Spieler an anderem Austragungsort agiert gerade...";
    private static final String ENDE = "Das Turnier ist beendet.";
    private int gewaehlt = 0;
    private int geworfen = 0;
    private boolean stellvertretend;

    static {
        int i = 0;
        while (i <= 5) {
            Becher.BECHER[i] = Grafik.icon("Becher" + i + ".gif");
            ++i;
        }
        WUERFELN = new Geraeusch[5];
        i = 0;
        while (i < 5) {
            Becher.WUERFELN[i] = new Geraeusch("Wuerfeln" + (i + 1) + ".wav");
            ++i;
        }
        SCHUETTELN = new Geraeusch("Schuetteln.wav");
    }

    public Becher() {
        this.setFocusable(false);
        this.setAlignmentX(0.5f);
        this.setToolTipText(WERFEN);
        this.setEnabled(false);
        this.setIcon(BECHER[0]);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(87, 0), this);
        this.getActionMap().put(this, new AbstractAction(){
            private static final int KLICKZEIT = 200;

            @Override
            public void actionPerformed(ActionEvent ev) {
                JButton button = (JButton)ev.getSource();
                button.doClick(200);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Wuerfelstand.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Wuerfelstand)((Object)umschlag.ereignis())) {
                case ANWAHL: {
                    ++this.gewaehlt;
                    this.aktualisiere();
                    break;
                }
                case ABWAHL: {
                    --this.gewaehlt;
                    this.aktualisiere();
                    break;
                }
                case WURF: {
                    ++this.geworfen;
                    break;
                }
            }
        } else if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: 
                case SPIEL: {
                    this.setIcon(BECHER[this.gewaehlt]);
                    this.aktualisiere(((Turnier)umschlag.quelle()).aktiver());
                }
                case FERTIG: {
                    SCHUETTELN.play(75);
                    this.aktualisiere(((Turnier)umschlag.quelle()).aktiver());
                    break;
                }
                case LEERUNG: {
                    this.leere();
                    break;
                }
                case GEWORFEN: {
                    this.aktualisiere(((Turnier)umschlag.quelle()).aktiver());
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.beende();
                    break;
                }
            }
        }
    }

    private void aktualisiere() {
        this.setEnabled(this.gewaehlt > 0 && !this.stellvertretend);
        this.setIcon(BECHER[this.gewaehlt]);
        this.setToolTipText(this.zustandsbeschreibung());
    }

    private void aktualisiere(Spieler aktiver) {
        this.stellvertretend = aktiver.stellvertretend();
        this.setEnabled(this.gewaehlt > 0 && !this.stellvertretend);
        this.setToolTipText(this.zustandsbeschreibung(aktiver));
    }

    private void beende() {
        this.gewaehlt = 0;
        this.geworfen = 0;
        this.setToolTipText(ENDE);
        this.setEnabled(false);
    }

    private void leere() {
        WUERFELN[this.geworfen - 1].play(75);
        this.geworfen = 0;
    }

    private String zustandsbeschreibung() {
        if (this.gewaehlt > 0) {
            return WERFEN;
        }
        return LEGEN;
    }

    private String zustandsbeschreibung(Spieler aktiv) {
        if (this.stellvertretend) {
            return VERTRETUNG;
        }
        if (aktiv.rest() == 0) {
            return SETZEN;
        }
        return this.zustandsbeschreibung();
    }
}

