/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.logik.Bot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Botstaerke
extends JDialog
implements PropertyChangeListener {
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private final JSlider[] staerkeneinstellungen = new JSlider[Bot.BOTNAMEN.length];

    Botstaerke(Eigenschaften eigenschaften) {
        UIManager.addPropertyChangeListener(this);
        this.setContentPane(this.baueDarstellungsfeld(eigenschaften));
        this.setModal(true);
        this.setTitle("JaFuffy (Spielst\u00e4rke der Bots)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    private JPanel baueDarstellungsfeld(Eigenschaften eigenschaften) {
        JPanel feld = new JPanel(new BorderLayout(0, 8));
        feld.setBorder(new EmptyBorder(8, 8, 8, 8));
        feld.add((Component)this.baueEinstellungsfeld(eigenschaften), "Center");
        feld.add((Component)this.baueLeistenfeld(eigenschaften), "Last");
        return feld;
    }

    private JPanel baueEinstellungsfeld(Eigenschaften eigenschaften) {
        Bot.Spielstaerke[] staerken;
        Hashtable<Integer, JLabel> bezeichnungen = new Hashtable<Integer, JLabel>();
        Bot.Spielstaerke[] spielstaerkeArray = staerken = Bot.Spielstaerke.values();
        int n = staerken.length;
        int n2 = 0;
        while (n2 < n) {
            Bot.Spielstaerke staerke = spielstaerkeArray[n2];
            bezeichnungen.put(staerke.ordinal(), new JLabel(staerke.toString()));
            ++n2;
        }
        JPanel einstellungen = new JPanel(new GridLayout(Bot.BOTNAMEN.length, 1, 0, 8));
        int index = 0;
        while (index < Bot.BOTNAMEN.length) {
            this.staerkeneinstellungen[index] = new JSlider(0, staerken.length - 1);
            this.staerkeneinstellungen[index].setBorder(BorderFactory.createCompoundBorder(new TitledBorder("Spielst\u00e4rke von " + Bot.BOTNAMEN[index]), new EmptyBorder(2, 2, 0, 2)));
            this.staerkeneinstellungen[index].setMajorTickSpacing(1);
            this.staerkeneinstellungen[index].setPaintLabels(true);
            this.staerkeneinstellungen[index].setLabelTable(bezeichnungen);
            einstellungen.add(this.staerkeneinstellungen[index]);
            String botstaerke = eigenschaften.getProperty("Botstaerke" + index);
            this.staerkeneinstellungen[index].setValue(Bot.Spielstaerke.valueOf(botstaerke).ordinal());
            ++index;
        }
        return einstellungen;
    }

    private JPanel baueLeistenfeld(final Eigenschaften eigenschaften) {
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int index = 0;
                while (index < Bot.BOTNAMEN.length) {
                    eigenschaften.setProperty("Botstaerke" + index, Bot.Spielstaerke.values()[Botstaerke.this.staerkeneinstellungen[index].getValue()].name());
                    ++index;
                }
                Botstaerke.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(ok);
        JButton abbruch = new JButton("Abbruch");
        abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int index = 0;
                while (index < Bot.BOTNAMEN.length) {
                    String botstaerke = eigenschaften.getProperty("Botstaerke" + index);
                    Botstaerke.this.staerkeneinstellungen[index].setValue(Bot.Spielstaerke.valueOf(botstaerke).ordinal());
                    ++index;
                }
                Botstaerke.this.setVisible(false);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(ok);
        leiste.add(abbruch);
        return leiste;
    }
}

