/******************************************************************************
 ** $Id: Nachricht.java 1679 2019-01-20 20:00:10Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.organisation;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Nachricht, die zwischen Spielern whrend der Abstimmung zu einem Turnier ber das Netzwerk ausgetauscht werden kann.
 */
class Nachricht implements Serializable {

    private static final long serialVersionUID = 1173292340173137584L;

    /** Kontaktdaten des Absenders dieser Nachricht. */
    private final Kontakt kontakt;
    /** Auflistung aller Teilnehmer, wie bei der Absprache gewhlt und auf dem Zettel angezeigt. */
    private final ArrayList<String> teilnehmer;
    /** Die zwischen Spielern ausgetauschte Nachricht. */
    private final String text;

    /**
     * Erstellt eine Nachricht.
     * 
     * @param kontakt
     *            Kontaktdaten des Absenders.
     * @param teilnehmer
     *            Teilnehmer an der Austragungssttte des Absenders.
     * @param text
     *            Optionale Nachricht, darf null sein.
     */
    Nachricht(Kontakt kontakt, ArrayList<String> teilnehmer, String text) {
        this.kontakt = kontakt;
        this.teilnehmer = teilnehmer;
        this.text = text;
    }

    /** Liefert Absenderadresse. */
    Kontakt kontakt() {
        return kontakt;
    }

    /** Liefert die Teilnehmer des Turniers der Austragungssttte, welche diese Nachricht verschickt hat. */
    ArrayList<String> teilnehmer() {
        return teilnehmer;
    }

    /** Liefert den optionalen Nachrichtentext. */
    String text() {
        return text;
    }

}
