/******************************************************************************
 ** $Id: Erweitert.java 1646 2019-01-12 05:33:11Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.auswertung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Wuerfel;

/** Erweiterte Auswertung. */
public class Erweitert extends Klassisch {

    /** Ermglicht Serialisierung. */
    private static final long serialVersionUID = 81708878516443751L;

    /** Die Klasse der Auswahl, die zu dieser Auswertung passt. */
    public static final Class<? extends Auswahl> AUSWAHLKLASSE = jafuffy.bedienung.auswahl.Erweitert.class;
    /** Regelname. */
    public static final String REGEL = "Erweiterte Regeln";

    /** Standardabweichung als grobe Schtzung fr das mittlere Spielergebnis. */
    private static final int ABWEICHUNG = 60;
    /** Erwartete Punktzahl pro Spiel als grobe Schtzung. */
    private static final int MITTELWERT = 240;

    /** Gibt an, ob eine Bonus-Nachricht angefordert ist. */
    private boolean istBonusnachrichtAngefordert = false;
    /** Gibt an, ob eine Joker-Nachricht angefordert ist. */
    private boolean istJokerNachrichtAngefordert = false;
    /** Gibt an, ob eine Setzzwang-Nachricht angefordert ist. */
    private boolean istSetzzwangNachrichtAngefordert = false;

    /**
     * Konstruktor.
     *
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     */
    public Erweitert(Wuerfel[] wuerfel) {
        super(wuerfel, new jafuffy.logik.analyse.Erweitert(wuerfel));
    }

    @Override
    public int abweichung() {
        return ABWEICHUNG;
    }

    @Override
    public int mittelwert() {
        return MITTELWERT;
    }

    @Override
    public String spicker(Kategorie kategorie) {
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && aktiver.gewuerfelt()
                && ((jafuffy.logik.analyse.Erweitert) analyse).istJokerVorliegend(aktiver)
                && kategorie == Kategorie.JAFUFFY) {
            String text;
            text = "<p align=center><em>Joker (+ 100 Bonuspunkte)!</em></p>"
                    + "<p>Bitte Wurf in freies Feld eintragen.</p>";
            if (sindTippsAngefordert()) {
                return "<html>" + text + "<p>Kontextmen!</p></html>";
            } else {
                return "<html>" + text + "</html>";
            }
        } else {
            return super.spicker(kategorie);
        }
    }

    @Override
    public String text(Kategorie kategorie) {
        if (kategorie == Kategorie.JAFUFFY && istJokerNachrichtAngefordert) {
            return "Joker!";
        } else if (kategorie == Kategorie.JAFUFFY && istBonusnachrichtAngefordert) {
            return "Bonus!";
        } else if (istSetzzwangNachrichtAngefordert && kategorie == Kategorie.oben(wuerfelsatz[0].augen())) {
            return "Gesetzt!";
        } else {
            return null;
        }
    }

    @Override
    public String toString() {
        return REGEL;
    }

    /**
     * Bestimmt das Anzeigen der Textnachricht "Bonus!".
     *
     * @param istBonusErzielt
     *            Gibt an, ob ein JaFuffy-Bonus erzielt wurde und damit die Nachricht gezeigt werden soll.
     */
    public void zeigeBonusnachricht(boolean istBonusErzielt) {
        istBonusnachrichtAngefordert = istBonusErzielt;
    }

    /**
     * Bestimmt das Anzeigen der Textnachricht "Joker!".
     *
     * @param istJokerVerfuegbar
     *            Gibt an, ob ein Joker vorliegt und damit die Nachricht gezeigt werden soll.
     */
    public void zeigeJokernachricht(boolean istJokerVerfuegbar) {
        if (istJokerVerfuegbar) {
            // Spieler darf keinen Wrfel mehr in den Becher legen
            for (Wuerfel w : wuerfelsatz) {
                w.darstellungsmodell().setEnabled(false);
            }
        }
        istJokerNachrichtAngefordert = istJokerVerfuegbar;
    }

    /**
     * Bestimmt das Anzeigen der Textnachricht "Gesetzt!".
     *
     * @param istSetzzwangGegeben
     *            Gibt an, ob Setzzwang vorliegt und damit die Nachricht gezeigt werden soll.
     */
    public void zeigeSetzzwangnachricht(boolean istSetzzwangGegeben) {
        if (istSetzzwangGegeben) {
            // Spieler darf keinen Wrfel mehr in den Becher legen
            for (Wuerfel w : wuerfelsatz) {
                w.darstellungsmodell().setEnabled(false);
            }
        }
        istSetzzwangNachrichtAngefordert = istSetzzwangGegeben;
    }

}
