/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Grafik;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class Oberflaeche
extends UIManager
implements PropertyChangeListener {
    private static final String LAFS = "/LaF/lafs.xml";
    private static final String NIMBUS = "Nimbus";
    private static final int WUERFELRAHMENBREITE = 6;
    public static final ArrayList<Image> LOGOS;
    private final Eigenschaften eigenschaften;

    static {
        Oberflaeche.wendeAnpassungenAn();
        Oberflaeche.installiereLookAndFeel(Oberflaeche.parseEinstellungsDatei());
        LOGOS = new ArrayList();
        LOGOS.add(Grafik.bild("Fensterlogo16.png"));
        LOGOS.add(Grafik.bild("Fensterlogo32.png"));
        LOGOS.add(Grafik.bild("Fensterlogo48.png"));
    }

    public static String standardLookAndFeel() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if (info.getName().equals(NIMBUS)) {
                return info.getClassName();
            }
            ++n2;
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static void starteJetzt(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void starteSpaeter(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private static void installiereLookAndFeel(TreeMap<String, String> lafs) {
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (Map.Entry<String, String> laf : lafs.entrySet()) {
            boolean vorhanden = false;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if (laf.getKey().equals(info.getClassName())) {
                    vorhanden = true;
                }
                ++n2;
            }
            if (vorhanden) continue;
            UIManager.installLookAndFeel(laf.getValue(), laf.getKey());
        }
    }

    private static TreeMap<String, String> parseEinstellungsDatei() {
        TreeMap<String, String> lafs = new TreeMap<String, String>();
        try {
            InputStream stream = Oberflaeche.class.getResourceAsStream(LAFS);
            if (stream != null) {
                Oberflaeche.parseEinstellungsDatei(lafs, stream);
            } else {
                System.out.println("Keine Verzeichnisdatei mit Look & Feel gefunden.");
            }
        }
        catch (XMLStreamException exception) {
            exception.printStackTrace();
        }
        return lafs;
    }

    private static void parseEinstellungsDatei(TreeMap<String, String> lafs, InputStream stream) throws FactoryConfigurationError, XMLStreamException {
        XMLEvent event;
        XMLInputFactory fabrik = XMLInputFactory.newInstance();
        XMLEventReader leser = fabrik.createXMLEventReader(stream);
        while (!(event = leser.nextEvent()).isStartElement() && leser.hasNext()) {
        }
        if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "lafs") {
            boolean geoeffnet = false;
            String implementierung = null;
            String name = null;
            while (leser.hasNext()) {
                event = leser.nextEvent();
                if (!geoeffnet) {
                    if (!event.isStartElement() || event.asStartElement().getName().getLocalPart() != "laf") continue;
                    geoeffnet = true;
                    continue;
                }
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "name") {
                    event = leser.nextEvent();
                    name = event.asCharacters().getData();
                }
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "class") {
                    event = leser.nextEvent();
                    implementierung = event.asCharacters().getData();
                }
                if (!event.isEndElement() || event.asEndElement().getName().getLocalPart() != "laf") continue;
                lafs.put(implementierung, name);
                geoeffnet = false;
            }
        }
    }

    private static String setzeLookAndFeel(String laf) {
        try {
            Oberflaeche.setLookAndFeel(laf);
        }
        catch (Exception erstversuchausnahme) {
            System.out.println(erstversuchausnahme.getStackTrace());
            laf = Oberflaeche.getCrossPlatformLookAndFeelClassName();
            try {
                Oberflaeche.setLookAndFeel(laf);
            }
            catch (Exception rueckfallausnahme) {
                rueckfallausnahme.printStackTrace();
                System.exit(-1);
            }
        }
        return laf;
    }

    private static void wendeAnpassungenAn() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        JDialog.setDefaultLookAndFeelDecorated(false);
        Oberflaeche.put("Table.showGrid", true);
        Oberflaeche.put("FileChooser.cancelButtonText", "Abbruch");
        Oberflaeche.put("FileChooser.cancelButtonToolTipText", "Abbruch der Auswahl");
        Oberflaeche.put("OptionPane.yesButtonText", "Ja");
        Oberflaeche.put("OptionPane.noButtonText", "Nein");
        Oberflaeche.put("OptionPane.cancelButtonText", "Abbruch");
        Oberflaeche.put("OptionPane.okButtonText", "OK");
        Oberflaeche.put("ToggleButton.contentMargins", new Insets(6, 6, 6, 6));
    }

    public Oberflaeche(Eigenschaften eigenschaften) {
        eigenschaften.setProperty("LookAndFeel", Oberflaeche.setzeLookAndFeel(eigenschaften.getProperty("LookAndFeel")));
        this.eigenschaften = eigenschaften;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.eigenschaften.setProperty("LookAndFeel", Oberflaeche.setzeLookAndFeel((String)event.getNewValue()));
    }
}

