/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Ressource;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.logik.Beginner;
import jafuffy.logik.Bot;
import jafuffy.logik.Variante;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Eigenschaften
extends Properties {
    private static final String HINWEIS = "JaFuffy-Einstellungen (bitte nicht von Hand \u00e4ndern)";
    private static final String INI = "JaFuffy.ini";
    private static final Vorbelegung VORBELEGUNG = new Vorbelegung(Ressource.soundsystem());
    public static final Eigenschaften GLOBAL;
    private final File ablage;

    static {
        File datei = null;
        try {
            String pfad = String.valueOf(System.getProperty("user.home")) + File.separator + INI;
            datei = new File(pfad);
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen verbieten Zugriff auf Heimverzeichnis: " + exception);
        }
        GLOBAL = new Eigenschaften(datei);
    }

    private Eigenschaften(File vorgabe) {
        super(VORBELEGUNG);
        File datei = vorgabe;
        if (vorgabe != null && vorgabe.exists()) {
            try {
                FileInputStream reader = new FileInputStream(vorgabe);
                this.load(reader);
                reader.close();
            }
            catch (IOException exeption) {
                exeption.printStackTrace();
                datei = null;
            }
            catch (SecurityException exception) {
                System.out.println("Sicherheitseinstellungen verbieten Einlesen der Eigenschaften: " + exception);
                datei = null;
            }
        }
        this.ablage = datei;
    }

    public boolean aktiv(String schluessel) {
        return this.getProperty(schluessel).equals(Status.AKTIV.name());
    }

    public int beginnmodus() {
        return Beginner.valueOf(this.getProperty("Beginnmodus")).ordinal();
    }

    public File datei(String name) {
        return new File(this.getProperty("Pfad"), name);
    }

    public boolean erststart() {
        return this.ablage != null && this.getProperty("Starts").equals("0");
    }

    public boolean kaltstart() {
        return this.getProperty("Neustart").equals("kalt");
    }

    public void merkeNeustartAnforderung(boolean warm) {
        this.setProperty("Neustart", warm ? "warm" : "kalt");
    }

    public boolean neustart() {
        return this.kaltstart() || this.warmstart();
    }

    public String pfad() {
        return this.getProperty("Pfad");
    }

    public void pfad(String pfad) {
        this.setProperty("Pfad", pfad);
    }

    public void quittiereNeustartAnforderung() {
        this.setProperty("Neustart", Status.PASSIV.name());
    }

    public void speichere(int x, int y, int b, int h) throws IOException {
        this.setProperty("X", String.valueOf(x));
        this.setProperty("Y", String.valueOf(y));
        this.setProperty("Breite", String.valueOf(b));
        this.setProperty("Hoehe", String.valueOf(h));
        this.setProperty("Starts", String.valueOf(Integer.parseInt(this.getProperty("Starts")) + 1));
        if (this.ablage != null) {
            FileOutputStream writer = new FileOutputStream(this.ablage);
            this.store(writer, HINWEIS);
            writer.close();
        }
    }

    public String spieler(int i) {
        return this.getProperty("Spieler" + i);
    }

    public int variante() {
        return Variante.valueOf(this.getProperty("Variante")).ordinal();
    }

    public boolean warmstart() {
        return this.getProperty("Neustart").equals("warm");
    }

    public void wechsle(String schluessel) {
        this.setProperty(schluessel, this.aktiv(schluessel) ? Status.PASSIV.name() : Status.AKTIV.name());
    }

    private static enum Status {
        PASSIV,
        AKTIV;

    }

    private static class Vorbelegung
    extends Properties {
        Vorbelegung(boolean soundsystem) {
            this.setProperty("Geraeusche", soundsystem ? Status.AKTIV.name() : Status.PASSIV.name());
            this.setProperty("LookAndFeel", Oberflaeche.standardLookAndFeel());
            this.setProperty("Variante", Variante.KLASSISCH.name());
            this.setProperty("Beginnmodus", Beginner.VERLIERER.name());
            this.setProperty("Anzahl", "0");
            this.setProperty("Einfachklick", Status.PASSIV.name());
            this.setProperty("Hinweis", Status.AKTIV.name());
            this.setProperty("Spicker", Status.AKTIV.name());
            this.setProperty("Erinnerung", Status.AKTIV.name());
            this.setProperty("Intro", Status.AKTIV.name());
            this.setProperty("Geraeusche", Status.AKTIV.name());
            this.setProperty("Breite", "640");
            this.setProperty("Hoehe", "480");
            this.setProperty("Nachschauen", Status.PASSIV.name());
            this.setProperty("Starts", "0");
            this.setProperty("Zwischenstand", Status.PASSIV.name());
            this.setProperty("Neustart", Status.PASSIV.name());
            try {
                this.setProperty("Pfad", System.getProperty("user.home"));
            }
            catch (SecurityException exception) {
                System.out.println("Sicherheitseinstellungen verbieten Speichern von Einstellungen, Statistiken, St\u00e4nden: " + exception);
            }
            Bot.Spielstaerke[] staerken = Bot.Spielstaerke.values();
            int i = 0;
            while (i < 4) {
                this.setProperty("Spieler" + i, "");
                this.setProperty("Botstaerke" + i, staerken[staerken.length - 1 - i].name());
                ++i;
            }
            this.setProperty("Ueberlegungsbestaetigung", Status.AKTIV.name());
            this.setProperty("Aktionsbeschleunigung", Status.PASSIV.name());
            this.setProperty("Geisterhand", Status.PASSIV.name());
        }
    }
}

