/******************************************************************************
 ** $Id: Kontakt.java 1678 2019-01-20 19:56:35Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.organisation;

import java.io.Serializable;
import java.net.InetAddress;

/** Kontaktdaten fr den Betrieb eines Turniers ber ein lokales Netzwerk. */
class Kontakt implements Serializable {

    private static final long serialVersionUID = 402027374401357074L;

    /** IP-Adresse fr Netzwerkbetrieb. */
    private final InetAddress adresse;
    /** Port-Nummer fr Netzwerkbetrieb. */
    private final int port;

    /**
     * Belegung mit Kontaktdaten.
     * 
     * @param adresse
     *            IP-Adresse
     * @param port
     *            Port-Nummer
     */
    Kontakt(InetAddress adresse, int port) {
        this.adresse = adresse;
        this.port = port;
    }

    /** Liefert IP-Adresse fr den Betrieb ber ein Netzwerk. */
    InetAddress adresse() {
        return adresse;
    }

    /** Liefert Port-Nummer fr den Betrieb ber ein Netzwerk. */
    int port() {
        return port;
    }

    /** Liefert Identifikation 'IP-Adresse':'Port-Nummer'. */
    String identifikation() {
        return adresse + ":" + port;
    }
}
