/******************************************************************************
 ** $Id: Signal.java 319 2011-02-23 00:18:53Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.sound.sampled.Clip;
import javax.swing.Timer;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;

/** Abspielen von Geruschen. */
public class Geraeusch {

    /**
     * @return Gibt an, ob Gerusch ausgegeben werden soll.
     */
    static boolean geraeusch() {
        return Eigenschaften.GLOBAL.aktiv("Geraeusche");
    }

    /** Gerusch, das abgespielt werden kann. */
    private final Clip clip;

    /**
     * Konstruktor.
     *
     * @param name
     *            Name der Ressource, die das Gerusch beschreibt.
     */
    public Geraeusch(final String name) {
        clip = Ressource.clip(name);
    }

    /** Gerusch abspielen. */
    public void play() {
        play(0);
    }

    /**
     * Falls Gerusche ausgegeben werden sollen: Pausiert und spielt danach ein Gerusch.
     *
     * @param pause
     *            Pause in Millisekunden
     */
    public void play(final int pause) {
        if (clip != null && geraeusch()) {
            final Timer timer = new Timer(pause, new ActionListener() {
                @Override
                public void actionPerformed(final ActionEvent exception) {
                    clip.setFramePosition(0);
                    clip.start();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

}
