/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.Range;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.AbstractXYZRenderer;
import com.orsoncharts.renderer.xyz.StandardXYZColorSource;
import com.orsoncharts.renderer.xyz.XYZColorSource;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class BarXYZRenderer
extends AbstractXYZRenderer
implements XYZRenderer,
Serializable {
    private double base = 0.0;
    private double barXWidth = 0.8;
    private double barZWidth = 0.8;
    private XYZColorSource baseColorSource = new StandardXYZColorSource(Color.WHITE);
    private XYZColorSource topColorSource = new StandardXYZColorSource(Color.BLACK);

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.fireChangeEvent(true);
    }

    public double getBarXWidth() {
        return this.barXWidth;
    }

    public void setBarXWidth(double width) {
        this.barXWidth = width;
        this.fireChangeEvent(true);
    }

    public double getBarZWidth() {
        return this.barZWidth;
    }

    public void setBarZWidth(double width) {
        this.barZWidth = width;
        this.fireChangeEvent(true);
    }

    public XYZColorSource getBaseColorSource() {
        return this.baseColorSource;
    }

    public void setBaseColorSource(XYZColorSource source) {
        this.baseColorSource = source;
        this.fireChangeEvent(true);
    }

    public XYZColorSource getTopColorSource() {
        return this.topColorSource;
    }

    public void setTopColorSource(XYZColorSource source) {
        this.topColorSource = source;
        this.fireChangeEvent(true);
    }

    @Override
    public Range findXRange(XYZDataset dataset) {
        Range xRange = DataUtils.findXRange(dataset);
        if (xRange == null) {
            return null;
        }
        double delta = this.barXWidth / 2.0;
        return new Range(xRange.getMin() - delta, xRange.getMax() + delta);
    }

    @Override
    public Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset, this.base);
    }

    @Override
    public Range findZRange(XYZDataset dataset) {
        Range zRange = DataUtils.findZRange(dataset);
        if (zRange == null) {
            return null;
        }
        double delta = this.barZWidth / 2.0;
        return new Range(zRange.getMin() - delta, zRange.getMax() + delta);
    }

    @Override
    public void composeItem(XYZDataset dataset, int series, int item, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        XYZPlot plot = this.getPlot();
        ValueAxis3D xAxis = plot.getXAxis();
        ValueAxis3D yAxis = plot.getYAxis();
        ValueAxis3D zAxis = plot.getZAxis();
        double x = dataset.getX(series, item);
        double y = dataset.getY(series, item);
        double z = dataset.getZ(series, item);
        double xdelta = this.barXWidth / 2.0;
        double zdelta = this.barZWidth / 2.0;
        double x0 = xAxis.getRange().peggedValue(x - xdelta);
        double x1 = xAxis.getRange().peggedValue(x + xdelta);
        double z0 = zAxis.getRange().peggedValue(z - zdelta);
        double z1 = zAxis.getRange().peggedValue(z + zdelta);
        if (x1 <= x0 || z1 <= z0) {
            return;
        }
        double ylow = Math.min(this.base, y);
        double yhigh = Math.max(this.base, y);
        Range range = yAxis.getRange();
        if (!range.intersects(ylow, yhigh)) {
            return;
        }
        double ybase = range.peggedValue(ylow);
        double ytop = range.peggedValue(yhigh);
        boolean inverted = this.base > y;
        double wx0 = xAxis.translateToWorld(x0, dimensions.getWidth());
        double wx1 = xAxis.translateToWorld(x1, dimensions.getWidth());
        double wy0 = yAxis.translateToWorld(ybase, dimensions.getHeight());
        double wy1 = yAxis.translateToWorld(ytop, dimensions.getHeight());
        double wz0 = zAxis.translateToWorld(z0, dimensions.getDepth());
        double wz1 = zAxis.translateToWorld(z1, dimensions.getDepth());
        Color color = this.getColorSource().getColor(series, item);
        Color baseColor = null;
        if (this.baseColorSource != null && !range.contains(this.base)) {
            baseColor = this.baseColorSource.getColor(series, item);
        }
        if (baseColor == null) {
            baseColor = color;
        }
        Color topColor = null;
        if (this.topColorSource != null && !range.contains(y)) {
            topColor = this.topColorSource.getColor(series, item);
        }
        if (topColor == null) {
            topColor = color;
        }
        Object3D bar = Object3D.createBar(wx1 - wx0, wz1 - wz0, (wx0 + wx1) / 2.0 + xOffset, wy1 + yOffset, (wz0 + wz1) / 2.0 + zOffset, wy0 + yOffset, color, baseColor, topColor, inverted);
        world.add(bar);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BarXYZRenderer)) {
            return false;
        }
        BarXYZRenderer that = (BarXYZRenderer)obj;
        if (this.base != that.base) {
            return false;
        }
        if (this.barXWidth != that.barXWidth) {
            return false;
        }
        if (this.barZWidth != that.barZWidth) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseColorSource, that.baseColorSource)) {
            return false;
        }
        if (!ObjectUtils.equals(this.topColorSource, that.topColorSource)) {
            return false;
        }
        return super.equals(obj);
    }
}

