/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Kategorie;
import jafuffy.logik.Spieler;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Analyse;
import jafuffy.logik.analyse.Klassisch;

public class ImHieb
extends Klassisch {
    private static final long serialVersionUID = 447027133112163377L;
    private static final int IM_HIEB_BONUS_MIN = 5;
    private static final int IM_HIEB_BONUS_MAX = 30;

    public ImHieb(Wuerfel[] wuerfelsatz) {
        super(wuerfelsatz);
    }

    public boolean istImHieb(Spieler spieler, Kategorie kategorie) {
        return kategorie.unten() && kategorie != Kategorie.CHANCE && this.istImHieb(spieler, this.wert(kategorie));
    }

    private boolean istImHieb(Spieler spieler, int wert) {
        return spieler.einmalig() && wert > 0;
    }

    @Override
    protected Analyse.Eintragungen eintragungen() {
        return new Eintragungen();
    }

    class Dreierpasch
    extends Klassisch.Dreierpasch {
        private static final long serialVersionUID = 5789475987451295504L;
        private static final double IM_HIEB_BONUS_MITTEL = 1.0648148148148149;

        Dreierpasch() {
            super(ImHieb.this);
            this.mittel += 1.0648148148148149;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 5;
            }
        }
    }

    class Eintragungen
    extends Analyse.Eintragungen {
        private static final long serialVersionUID = -226404933174352144L;

        Eintragungen() {
            this.put(Kategorie.DREIERPASCH, new Dreierpasch());
            this.put(Kategorie.VIERERPASCH, new Viererpasch());
            this.put(Kategorie.FULLHOUSE, new FullHouse());
            this.put(Kategorie.KLEINESTRASSE, new KleineStrasse());
            this.put(Kategorie.GROSSESTRASSE, new GrosseStrasse());
            this.put(Kategorie.JAFUFFY, new JaFuffy());
        }
    }

    class FullHouse
    extends Klassisch.FullHouse {
        private static final long serialVersionUID = -3227165375021646796L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.19675925925925927;

        FullHouse() {
            super(ImHieb.this);
            this.mittel += 0.19675925925925927;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 5;
            }
        }
    }

    class GrosseStrasse
    extends Klassisch.GrosseStrasse {
        private static final long serialVersionUID = -2371420977396166725L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.15432098765432098;

        GrosseStrasse() {
            super(ImHieb.this);
            this.mittel += 0.15432098765432098;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 5;
            }
        }
    }

    class JaFuffy
    extends Klassisch.JaFuffy {
        private static final long serialVersionUID = -4640248861129674120L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.023148148148148147;

        JaFuffy() {
            super(ImHieb.this);
            this.mittel += 0.023148148148148147;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 30;
            }
        }
    }

    class KleineStrasse
    extends Klassisch.KleineStrasse {
        private static final long serialVersionUID = 1874639430274154259L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.7716049382716049;

        KleineStrasse() {
            super(ImHieb.this);
            this.mittel += 0.7716049382716049;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 5;
            }
        }

        @Override
        protected void waehle(Spieler spieler) {
            this.waehle(this.liegtKleineStrasseVor());
        }
    }

    class Viererpasch
    extends Klassisch.Viererpasch {
        private static final long serialVersionUID = 5628384303623911087L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.10030864197530864;

        Viererpasch() {
            super(ImHieb.this);
            this.mittel += 0.10030864197530864;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (ImHieb.this.istImHieb(spieler, this.wert)) {
                this.wert += 5;
            }
        }
    }
}

