/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Kategorie;
import jafuffy.logik.Spieler;
import jafuffy.logik.auswertung.Auswertung;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class Punkte
extends AbstractTableModel {
    private final ArrayList<Spieler> teilnehmer;
    private final Auswertung auswertung;
    private boolean auswaehlbar = true;

    Punkte(ArrayList<Spieler> teilnehmer, Auswertung auswertung) {
        this.teilnehmer = teilnehmer;
        this.auswertung = auswertung;
    }

    public boolean aktiv(int index) {
        Spieler spieler = this.teilnehmer.get(index);
        return spieler.rest() > 0 || spieler.gewuerfelt();
    }

    public boolean angefangen(int index) {
        return this.aktiv(index) && this.teilnehmer.get(index).rest() < 3;
    }

    public void auswaehlbar(boolean auswaehlbar) {
        this.auswaehlbar = auswaehlbar;
    }

    public Auswertung auswertung() {
        return this.auswertung;
    }

    public void benachrichtige(int index) {
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, index));
    }

    @Override
    public int getColumnCount() {
        return this.teilnehmer.size();
    }

    @Override
    public String getColumnName(int spalte) {
        return this.teilnehmer.get(spalte).toString();
    }

    @Override
    public int getRowCount() {
        return Kategorie.ANZAHL;
    }

    @Override
    public Object getValueAt(int zeile, int spalte) {
        return this.teilnehmer.get(spalte).punkte(Kategorie.kategorie(zeile));
    }

    @Override
    public boolean isCellEditable(int zeile, int spalte) {
        Spieler spieler = this.teilnehmer.get(spalte);
        return spieler.gewuerfelt() && spieler.setzbar(Kategorie.kategorie(zeile)) && this.auswaehlbar;
    }

    public boolean offen(int index) {
        return this.teilnehmer.get(index).rest() > 0;
    }

    public boolean setzbar(int zeile, int spalte) {
        return this.teilnehmer.get(spalte).setzbar(Kategorie.kategorie(zeile));
    }
}

