/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Statistik;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class Bestenlistenmodell
extends AbstractTableModel {
    private static final int RANG = 0;
    private static final int NAME = 1;
    private static final int PUNKTE = 2;
    private static final int DATUM = 3;
    private static final int KOMMENTAR = 4;
    private static final String[] SPALTENTITEL = new String[]{"Rang", "Name", "Punkte", "Datum", "Kommentar"};
    private static final Class<?>[] SPALTENTYP = new Class[]{Integer.class, String.class, Integer.class, String.class, String.class};
    private final ArrayList<Statistik.Rang> rangliste;
    private ArrayList<Zeile> zeilen;

    Bestenlistenmodell(ArrayList<Statistik.Rang> rangliste) {
        this.rangliste = rangliste;
        this.aktualisieren();
    }

    public void aktualisieren() {
        this.zeilen = new ArrayList();
        for (Statistik.Rang rang : this.rangliste) {
            for (Statistik.Rang.Eintrag eintrag : rang.eintraege()) {
                this.zeilen.add(new Zeile(rang.rangnummer(), eintrag.name(), rang.punkte(), eintrag.datum(), eintrag.kommentar()));
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return SPALTENTITEL[col];
    }

    @Override
    public int getColumnCount() {
        return SPALTENTITEL.length;
    }

    @Override
    public int getRowCount() {
        return this.zeilen == null ? 0 : this.zeilen.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.zeilen.get(row).rang;
            }
            case 1: {
                return this.zeilen.get(row).name;
            }
            case 2: {
                return this.zeilen.get(row).punkte;
            }
            case 3: {
                return this.zeilen.get(row).datum;
            }
            case 4: {
                return this.zeilen.get(row).kommentar;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return SPALTENTYP[col];
    }

    private static class Zeile {
        private final int rang;
        private final String name;
        private final int punkte;
        private final String datum;
        private final String kommentar;

        Zeile(int rang, String name, int punkte, String datum, String kommentar) {
            this.rang = rang;
            this.name = name;
            this.punkte = punkte;
            this.datum = datum;
            this.kommentar = kommentar;
        }
    }
}

