/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Eroeffnung;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.organisation.Organisation;
import jafuffy.logik.Beginner;
import jafuffy.logik.Bot;
import jafuffy.logik.Manager;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Variante;
import jafuffy.organisation.Leitung;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class Absprache
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final ImageIcon BOT_AKTIV = Grafik.icon("Aktivbot.png");
    private static final ImageIcon BOT_RUHT = Grafik.icon("Ruhebot.png");
    private static final int ANZAHL = 20;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int BUTTONABSTAND = 8;
    private static final int FEINTICKS = 1;
    private static final int ORIENTIERUNGSTICKS = 5;
    private static final int SPALTEN = 8;
    private static final int TICKLABELS = 5;
    private final JSlider anzahlschieberegler = new JSlider(0, 20);
    private final JComboBox<Beginner> beginnmodusauswahl = new JComboBox<Beginner>(Beginner.values());
    private final Eigenschaften eigenschaften;
    private final Manager manager;
    private final JComboBox<Variante> variantenauswahl = new JComboBox<Variante>(Variante.values());
    private final Nominierung[] nominierungen = new Nominierung[4];
    private final Botselektion[] botselektionen = new Botselektion[4];
    private final JButton netzwerkorganisation = new JButton("Organisation \u00fcber Netzwerk");
    private final JButton ok = new JButton("OK");
    private final JButton abbruch = new JButton("Abbruch");

    public Absprache(Eigenschaften eigenschaften, Manager manager) {
        this.eigenschaften = eigenschaften;
        this.manager = manager;
        UIManager.addPropertyChangeListener(this);
        this.baue();
        this.installiere();
        this.aktualisiere();
        this.setTitle("JaFuffy (Daten f\u00fcr neues Turnier)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String kommmando;
        switch (kommmando = event.getActionCommand()) {
            case "Abbruch": {
                this.aktualisiere();
                this.ok.requestFocus();
                this.setVisible(false);
                break;
            }
            case "OK": {
                ArrayList<Spieler> teilnehmer = this.uebernehmeTeilnehmer();
                this.manager.betreibe(new Turnier(this.uebernehmeVariante(), teilnehmer, this.erster(teilnehmer), this.uebernehmeBeginnmodus(), this.uebernehmeAnzahl()));
                this.ok.requestFocus();
                this.setVisible(false);
                break;
            }
            case "Abstimmung": {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Leitung leitung = new Leitung(this.teilnehmer());
                            Absprache.this.netzwerkorganisation.addActionListener(leitung);
                            Organisation organisation = new Organisation(leitung);
                            organisation.setLocationRelativeTo(Absprache.this);
                            organisation.setVisible(true);
                            Absprache.this.netzwerkorganisation.removeActionListener(leitung);
                        }
                        catch (UnknownHostException exception) {
                            JOptionPane.showMessageDialog(Absprache.this, "Kein Turnier \u00fcber Netzwork m\u00f6glich!\nKein Netzwerk verf\u00fcgbar?\nJava-Exception:\n" + exception, "JaFuffy (Fehler)", 0);
                        }
                    }

                    private ArrayList<String> teilnehmer() {
                        ArrayList<String> teilnehmer = new ArrayList<String>();
                        Nominierung[] nominierungArray = Absprache.this.nominierungen;
                        int n = nominierungArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Nominierung nominierung = nominierungArray[n2];
                            String name = nominierung.toString();
                            if (!name.isEmpty()) {
                                teilnehmer.add(name);
                            }
                            ++n2;
                        }
                        return teilnehmer;
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Beginnen")) {
            this.setLocationRelativeTo((JRootPane)event.getNewValue());
            this.setVisible(true);
        } else if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    private JPanel anzahlauswahl() {
        JLabel label = new JLabel("Anzahl der Spiele im Turnier");
        label.setAlignmentX(0.5f);
        int anzahl = Integer.parseInt(this.eigenschaften.getProperty("Anzahl"));
        this.anzahlschieberegler.setValue(anzahl);
        this.anzahlschieberegler.setMinorTickSpacing(1);
        this.anzahlschieberegler.setMajorTickSpacing(5);
        this.anzahlschieberegler.setPaintTicks(true);
        this.anzahlschieberegler.setPaintLabels(true);
        this.anzahlschieberegler.setSnapToTicks(true);
        Hashtable<Integer, JComponent> hashtable = this.anzahlschieberegler.createStandardLabels(5);
        hashtable.put(0, new JLabel("beliebig"));
        this.anzahlschieberegler.setLabelTable(hashtable);
        JPanel anzahlfeld = new JPanel();
        anzahlfeld.setLayout(new BoxLayout(anzahlfeld, 1));
        anzahlfeld.add(label);
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(Box.createVerticalGlue());
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(this.anzahlschieberegler);
        return anzahlfeld;
    }

    private void baue() {
        JPanel regelnfeld = new JPanel(new BorderLayout());
        regelnfeld.add((Component)this.regelnfeld(), "Center");
        JPanel buttonspalte = new JPanel(new BorderLayout());
        buttonspalte.add((Component)this.buttonspalte(), "Center");
        JPanel feld = new JPanel();
        feld.setBorder(new EmptyBorder(8, 8, 8, 8));
        feld.setLayout(new BoxLayout(feld, 0));
        feld.add(this.nominierungsfeld());
        feld.add(Box.createHorizontalStrut(4));
        feld.add(regelnfeld);
        feld.add(Box.createHorizontalStrut(4));
        feld.add(buttonspalte);
        this.setContentPane(feld);
    }

    private JPanel buttonspalte() {
        JPanel buttonspalte = new JPanel(new GridLayout(0, 1, 0, 8));
        buttonspalte.setBorder(BorderFactory.createEmptyBorder(16, 4, 16, 4));
        buttonspalte.add(this.ok);
        buttonspalte.add(this.abbruch);
        return buttonspalte;
    }

    private Spieler erster(ArrayList<Spieler> teilnehmer) {
        Spieler erster = teilnehmer.get(0);
        if (teilnehmer.size() > 1) {
            Eroeffnung eroeffnung = new Eroeffnung(teilnehmer);
            eroeffnung.addPropertyChangeListener(this);
            eroeffnung.setLocationRelativeTo(this);
            eroeffnung.setVisible(true);
            eroeffnung.dispose();
            erster = eroeffnung.erster();
        }
        return erster;
    }

    private void installiere() {
        this.netzwerkorganisation.setActionCommand("Abstimmung");
        this.netzwerkorganisation.addActionListener(this);
        this.netzwerkorganisation.setToolTipText("<html><p>Organisiert ein Turnier \u00fcber ein lokales Netzwerk.</p><p>Erlaubt Hinzuf\u00fcgen von Mitspielern, die \u00fcber das Netzwerk teilnehmen.</p><br><p><small><em>Experimentell! Volle Funktionalit\u00e4t steht nicht zur Verf\u00fcgung.</em></small></p></html>");
        this.abbruch.addActionListener(this);
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
    }

    private void konfiguriereBeginnmodusauswahl() {
        this.beginnmodusauswahl.setAlignmentX(0.5f);
        this.beginnmodusauswahl.setSelectedIndex(this.eigenschaften.beginnmodus());
        this.beginnmodusauswahl.setToolTipText("Auswahl, welcher Mitspieler jedes neue Spiel beginnt");
    }

    private void konfiguriereVariantenauswahl() {
        this.variantenauswahl.setActionCommand("Var");
        this.variantenauswahl.setAlignmentX(0.5f);
        this.variantenauswahl.setSelectedIndex(this.eigenschaften.variante());
        this.variantenauswahl.setToolTipText("Nach welchen Spielregeln soll gespielt werden?");
    }

    private JPanel netzwerkorganisationsfeld() {
        JPanel netzwerkorganisationsfeld = new JPanel(new BorderLayout());
        netzwerkorganisationsfeld.setBorder(BorderFactory.createEmptyBorder(8, 0, 2, 0));
        netzwerkorganisationsfeld.add((Component)this.netzwerkorganisation, "Center");
        return netzwerkorganisationsfeld;
    }

    private JPanel nominierungsfeld() {
        JPanel nominierungsfeld = new JPanel(new BorderLayout());
        nominierungsfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Namen"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        nominierungsfeld.add((Component)this.spielerfestlegung(), "First");
        nominierungsfeld.add((Component)this.netzwerkorganisationsfeld(), "Center");
        return nominierungsfeld;
    }

    private JPanel regelnfeld() {
        this.konfiguriereVariantenauswahl();
        this.konfiguriereBeginnmodusauswahl();
        JPanel regelnfeld = new JPanel();
        regelnfeld.setLayout(new BoxLayout(regelnfeld, 1));
        regelnfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Regeln"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        regelnfeld.add(this.beginnmodusauswahl);
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(this.variantenauswahl);
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(this.anzahlauswahl());
        regelnfeld.add(Box.createVerticalGlue());
        return regelnfeld;
    }

    private JPanel spielerfestlegung() {
        JPanel spielerfestlegung = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(1, 0, 1, 0);
        LinkedList<String> botnamen = new LinkedList<String>(Arrays.asList(Bot.BOTNAMEN));
        int i = 0;
        while (i < 4) {
            String botname = this.eigenschaften.getProperty("Bot" + i);
            if (!botname.isEmpty()) {
                botnamen.remove(botname);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            boolean kuenstlich;
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.ipadx = 8;
            constraints.fill = 3;
            constraints.weightx = 0.0;
            String name = this.eigenschaften.getProperty("Bot" + i);
            boolean bl = kuenstlich = !name.isEmpty();
            if (!kuenstlich) {
                name = this.eigenschaften.getProperty("Spieler" + i);
            }
            this.nominierungen[i] = new Nominierung(kuenstlich, name, botnamen, this);
            this.variantenauswahl.addActionListener(this.nominierungen[i]);
            this.botselektionen[i] = new Botselektion(kuenstlich, this.nominierungen[i], this.variantenauswahl);
            this.variantenauswahl.addActionListener(this.botselektionen[i]);
            spielerfestlegung.add((Component)this.botselektionen[i], constraints);
            constraints.anchor = 10;
            constraints.gridx = 1;
            constraints.ipadx = 4;
            constraints.weightx = 0.0;
            JLabel kopf = new JLabel(String.valueOf(i + 1) + ". Spieler: ", 0);
            kopf.setToolTipText("Eingabe der Spielernamen, bis zu 14 Zeichen.");
            spielerfestlegung.add((Component)kopf, constraints);
            constraints.anchor = 22;
            constraints.gridx = 2;
            constraints.ipadx = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            spielerfestlegung.add((Component)this.nominierungen[i], constraints);
            ++i;
        }
        return spielerfestlegung;
    }

    private int uebernehmeAnzahl() {
        this.eigenschaften.setProperty("Anzahl", Integer.toString(this.anzahlschieberegler.getValue()));
        return this.anzahlschieberegler.getValue();
    }

    private Beginner uebernehmeBeginnmodus() {
        Beginner beginnmodus = Beginner.values()[this.beginnmodusauswahl.getSelectedIndex()];
        this.eigenschaften.setProperty("Beginnmodus", beginnmodus.name());
        return beginnmodus;
    }

    private ArrayList<Spieler> uebernehmeTeilnehmer() {
        ArrayList<Spieler> teilnehmer = new ArrayList<Spieler>(4);
        int index = 0;
        while (index < 4) {
            this.eigenschaften.setProperty("Spieler" + index, "");
            this.eigenschaften.setProperty("Bot" + index, "");
            ++index;
        }
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            String name = nominierung.toString();
            if (!name.isEmpty()) {
                if (nominierung.kuenstlich()) {
                    this.eigenschaften.setProperty("Bot" + teilnehmer.size(), name);
                    teilnehmer.add(new Bot(this.eigenschaften, name, teilnehmer.size()));
                } else {
                    this.eigenschaften.setProperty("Spieler" + teilnehmer.size(), name);
                    teilnehmer.add(new Spieler(name, teilnehmer.size()));
                }
                nominierung.spielernameneingabe.setText(name);
            }
            ++n2;
        }
        return teilnehmer;
    }

    private Variante uebernehmeVariante() {
        Variante variante = (Variante)((Object)this.variantenauswahl.getSelectedItem());
        this.eigenschaften.setProperty("Variante", variante.name());
        return variante;
    }

    void aktualisiere() {
        int spieleranzahl = 0;
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (!nominierung.toString().isEmpty()) {
                ++spieleranzahl;
            }
            ++n2;
        }
        this.beginnmodusauswahl.setEnabled(spieleranzahl > 1);
        this.ok.setEnabled(spieleranzahl > 0);
        this.netzwerkorganisation.setEnabled(spieleranzahl > 0);
    }

    void entferne(Nominierung verursacher, String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (nominierung != verursacher && nominierung.kuenstlich()) {
                nominierung.entferne(botname);
            }
            ++n2;
        }
    }

    void erweitere(Nominierung verursacher, String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (nominierung != verursacher && nominierung.kuenstlich()) {
                nominierung.erweitere(botname);
            }
            ++n2;
        }
    }

    boolean istBotnameFrei(String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (botname.equals(nominierung.toString())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static class Botselektion
    extends JCheckBox
    implements ActionListener {
        private static final Color BOT_INAKTIV_FARBE = Color.GRAY;
        private static final Color BOT_AKTIV_FARBE = Color.ORANGE.darker();
        private final JComboBox<Variante> variantenauswahl;

        Botselektion(boolean kuenstlich, Nominierung nominierung, JComboBox<Variante> variantenauswahl) {
            super("Bot");
            this.variantenauswahl = variantenauswahl;
            this.addActionListener(nominierung);
            this.setIcon(BOT_RUHT);
            this.setRolloverIcon(BOT_AKTIV);
            this.setSelectedIcon(BOT_AKTIV);
            this.setSelected(kuenstlich);
            this.setToolTipText("<html><p>Wenn angew\u00e4hlt, \u00fcbernimmt <i>JaFuffy</i> die Rolle des Spielers.</p><p><small>Spielst\u00e4rke im Men\u00fc: Einstellungen&rarr;Botverhalten&rarr;Spielst\u00e4rke der Bots...</small></p><p><small>Bot steht bei erweiterten Regeln nicht zur Verf\u00fcgung.</small></p></html>");
            this.addActionListener(this);
            boolean botfaehig = variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
            this.setEnabled(botfaehig);
            if (botfaehig) {
                if (this.isSelected()) {
                    this.setForeground(BOT_AKTIV_FARBE);
                } else {
                    this.setForeground(BOT_INAKTIV_FARBE);
                }
            } else {
                this.setSelected(false);
                this.setForeground(Color.LIGHT_GRAY);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean botfaehig = this.variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
            this.setEnabled(botfaehig);
            if (botfaehig) {
                if (this.isSelected()) {
                    this.setForeground(BOT_AKTIV_FARBE);
                } else {
                    this.setForeground(BOT_INAKTIV_FARBE);
                }
            } else {
                this.setSelected(false);
                this.setForeground(Color.LIGHT_GRAY);
            }
        }
    }

    private static class Nominierung
    extends JPanel
    implements ActionListener {
        private static final String MENSCH = "Mensch";
        private static final String BOT = "Bot";
        private static final int EINGABELAENGE = 14;
        private final Absprache absprache;
        private final JTextField spielernameneingabe = new JTextField(8);
        private final JComboBox<String> botnamenauswahl = new JComboBox();
        private boolean kuenstlich;

        Nominierung(boolean kuenstlich, String name, List<String> botnamen, Absprache absprache) {
            super(new CardLayout());
            this.absprache = absprache;
            this.kuenstlich = kuenstlich;
            ((AbstractDocument)this.spielernameneingabe.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (this.gefiltert(fb, offset, 0, string, attr)) {
                        return;
                    }
                    super.insertString(fb, offset, string, attr);
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                    if (this.gefiltert(fb, offset, length, string, attr)) {
                        return;
                    }
                    super.replace(fb, offset, length, string, attr);
                }

                private boolean gefiltert(DocumentFilter.FilterBypass fb, int offset, int laenge, String string, AttributeSet attr) {
                    boolean gefiltert;
                    boolean bl = gefiltert = fb.getDocument().getLength() - laenge + string.length() > 14 || offset == 0 && Character.isWhitespace(string.charAt(0));
                    if (gefiltert) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    return gefiltert;
                }
            });
            this.uebernehmeVorbelegung(name, botnamen);
            this.erstelleKarten();
            this.verbindeBeobachter();
            this.setToolTipText("FooBar");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String kommando = event.getActionCommand();
            if (kommando.equals(BOT)) {
                this.botnamenauswahl.removeAllItems();
                JCheckBox entscheidung = (JCheckBox)event.getSource();
                this.kuenstlich = entscheidung.isSelected();
                if (this.kuenstlich) {
                    String[] stringArray = Bot.BOTNAMEN;
                    int n = Bot.BOTNAMEN.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String botname = stringArray[n2];
                        if (this.absprache.istBotnameFrei(botname)) {
                            this.botnamenauswahl.addItem(botname);
                        }
                        ++n2;
                    }
                    CardLayout layout = (CardLayout)this.getLayout();
                    layout.show(this, BOT);
                } else {
                    CardLayout layout = (CardLayout)this.getLayout();
                    layout.show(this, MENSCH);
                }
                this.absprache.aktualisiere();
            } else if (kommando.equals("Var")) {
                boolean botfaehig;
                JComboBox variantenauswahl = (JComboBox)event.getSource();
                boolean bl = botfaehig = variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
                if (!botfaehig) {
                    this.kuenstlich = false;
                    CardLayout layout = (CardLayout)this.getLayout();
                    layout.show(this, MENSCH);
                }
            }
        }

        @Override
        public String toString() {
            return this.kuenstlich ? (String)this.botnamenauswahl.getSelectedItem() : this.spielernameneingabe.getText().trim();
        }

        private void erstelleKarten() {
            this.add((Component)this.spielernameneingabe, MENSCH);
            this.add(this.botnamenauswahl, BOT);
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show(this, this.kuenstlich ? BOT : MENSCH);
        }

        private void uebernehmeVorbelegung(String name, List<String> botnamen) {
            if (this.kuenstlich) {
                this.botnamenauswahl.addItem(name);
                for (String botname : botnamen) {
                    this.botnamenauswahl.addItem(botname);
                }
            } else {
                this.spielernameneingabe.setText(name);
            }
        }

        private void verbindeBeobachter() {
            this.spielernameneingabe.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }

                @Override
                public void insertUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }

                @Override
                public void removeUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }
            });
            this.botnamenauswahl.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        absprache.entferne(this, event.getItem().toString());
                    } else {
                        absprache.erweitere(this, event.getItem().toString());
                    }
                }
            });
        }

        void entferne(String botname) {
            this.botnamenauswahl.removeItem(botname);
        }

        void erweitere(String botname) {
            this.botnamenauswahl.addItem(botname);
        }

        boolean kuenstlich() {
            return this.kuenstlich;
        }
    }
}

