/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum Ressource {
    ANLEITUNG("/Anleitung/"),
    LIESMICH("/Liesmich/"),
    SOUND("sounds/"),
    ICON("icons/");

    private static boolean stumm;
    private final String art;

    static {
        stumm = false;
    }

    public static Clip clip(String name) {
        if (Ressource.soundsystem()) {
            try {
                AudioInputStream stream = AudioSystem.getAudioInputStream(SOUND.url(name));
                DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat());
                Clip clip = (Clip)AudioSystem.getLine(info);
                try {
                    clip.open(stream);
                }
                catch (LineUnavailableException exception) {
                    exception.printStackTrace();
                }
                return clip;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void schalteStumm() {
        stumm = true;
    }

    public static boolean soundsystem() {
        return !stumm && AudioSystem.getMixerInfo().length > 0;
    }

    private Ressource(String art) {
        this.art = art;
    }

    public URL url(String name) {
        URL url = Ressource.class.getResource(String.valueOf(this.art) + name);
        if (url == null) {
            System.out.println("Ressource \"" + this.art + name + "\" nicht gefunden!");
        }
        return url;
    }
}

