/******************************************************************************
 ** $Id: Annahme.java 1677 2019-01-20 19:53:07Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.organisation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;

/** Nimmt Anmeldungen entgegen. */
class Annahme extends Thread {

    /** Puffergre fr die Entgegennahme der Nachrichten. */
    private static final int PUFFERGROESSE = 1000;

    /** Verwalten Property-Change-Listener. */
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    /** Socket fr die Organisation eines Turniers ber ein lokales Netzwerk. */
    private final MulticastSocket socket;

    /**
     * Erzeugt die Annahme zur Entgegennahme der Anmeldungen.
     * 
     * @param socket
     *            Socket fr die Organisation des Turnierbetriebs.
     */
    Annahme(MulticastSocket socket) {
        this.socket = socket;
    }

    @Override
    public void run() {
        byte[] puffer = new byte[PUFFERGROESSE];
        while (true) {
            DatagramPacket paket = new DatagramPacket(puffer, puffer.length);
            try {
                socket.receive(paket);
                ObjectInputStream objektstrom;
                ByteArrayInputStream bytestream = new ByteArrayInputStream(puffer);
                objektstrom = new ObjectInputStream(bytestream);
                Object objekt = objektstrom.readObject();
                Nachricht nachricht = (Nachricht) objekt;
                pcs.firePropertyChange("Nachricht", null, nachricht);
            } catch (SocketException exception) {
                return;
            } catch (IOException | ClassNotFoundException exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    void addPropertyChangeListener(String eigenschaft, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(eigenschaft, listener);
    }

    void removePropertyChangeListener(String eigenschaft, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(eigenschaft, listener);
    }
}