/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung.organisation;

import jafuffy.bedienung.Oberflaeche;
import jafuffy.organisation.Leitung;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Organisation
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 447129931870861281L;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private static final int TABELLENHOEHE = 64;
    private static final int NACHRICHTENANZEIGENHOEHE = 100;
    private static final int EINGABELAENGE = 60;
    private static SimpleAttributeSet IDENTIFIKATIONSFORMAT = new SimpleAttributeSet();
    private static SimpleAttributeSet TEILNEHMERFORMAT = new SimpleAttributeSet();
    private final JButton aufnahme;
    private final JButton abbruch;
    private final JTextField eingabe;
    private final JButton senden;
    private final JTable tabelle;
    private final StyledDocument chatverlauf;
    private final Leitung leitung;

    public Organisation(final Leitung leitung) {
        StyleConstants.setFontSize(IDENTIFIKATIONSFORMAT, 10);
        StyleConstants.setForeground(IDENTIFIKATIONSFORMAT, Color.GREEN.darker().darker());
        StyleConstants.setFontSize(TEILNEHMERFORMAT, 10);
        StyleConstants.setForeground(TEILNEHMERFORMAT, Color.GREEN.darker().darker());
        StyleConstants.setBold(TEILNEHMERFORMAT, true);
        this.aufnahme = new JButton("Aufnahme");
        this.abbruch = new JButton("Abbruch");
        this.eingabe = new JTextField(60);
        this.senden = new JButton("Senden");
        this.tabelle = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.chatverlauf = new DefaultStyledDocument();
        this.leitung = leitung;
        this.installiere();
        this.setTitle("JaFuffy (Organisation f\u00fcr Netzwerkbetrieb)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.getRootPane().setDefaultButton(this.aufnahme);
        this.setContentPane(this.hauptfeld());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                leitung.actionPerformed(new ActionEvent(this, 1001, Organisation.this.abbruch.getActionCommand()));
                Organisation.this.dispose();
            }
        });
        this.setModal(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand() == this.aufnahme.getActionCommand()) {
            System.out.println(this + ": " + event);
        } else if (event.getActionCommand() == this.abbruch.getActionCommand()) {
            this.dispose();
        }
        this.deinstalliere();
    }

    private JPanel abstimmungsfeld() {
        JPanel abstimmungsfeld = new JPanel(new BorderLayout());
        abstimmungsfeld.add((Component)this.nachrichtenfeld(), "Center");
        abstimmungsfeld.add((Component)this.eingabefeld(), "Last");
        return abstimmungsfeld;
    }

    private void deinstalliere() {
        this.tabelle.setModel(new DefaultTableModel());
        this.aufnahme.removeActionListener(this.leitung);
        this.abbruch.removeActionListener(this.leitung);
        this.removePropertyChangeListener(this.leitung);
        this.leitung.verfolge(null);
    }

    private JPanel eingabefeld() {
        this.senden.setToolTipText("Versendet obige Nachricht von bis zu 60 Zeichen an alle JaFuffy-Instanzen.");
        this.senden.setEnabled(false);
        JPanel eingabefeld = new JPanel(new BorderLayout(0, 2));
        eingabefeld.setToolTipText("Optional k\u00f6nnen hier Nachrichten an alle Austragungst\u00e4tten versendet werden.");
        eingabefeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Nachrichtenversand"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        eingabefeld.add((Component)this.eingabe, "First");
        eingabefeld.add((Component)this.senden, "Last");
        return eingabefeld;
    }

    private JPanel hauptfeld() {
        JPanel feld = new JPanel(new BorderLayout(0, 4));
        feld.setBorder(new EmptyBorder(8, 8, 8, 8));
        feld.add((Component)this.tabellenfeld(), "First");
        feld.add((Component)this.abstimmungsfeld(), "Center");
        feld.add((Component)this.leiste(), "Last");
        return feld;
    }

    private void installiere() {
        this.addPropertyChangeListener("Senden", this.leitung);
        this.leitung.verfolge(new Leitung.Chat(){

            @Override
            public void zeige(String identifikation, String teilnehmer, String text) {
                try {
                    if (Organisation.this.chatverlauf.getLength() > 0) {
                        Organisation.this.chatverlauf.insertString(Organisation.this.chatverlauf.getLength(), "\n", null);
                    }
                    Organisation.this.chatverlauf.insertString(Organisation.this.chatverlauf.getLength(), teilnehmer, TEILNEHMERFORMAT);
                    Organisation.this.chatverlauf.insertString(Organisation.this.chatverlauf.getLength(), " @ " + identifikation + "\n", IDENTIFIKATIONSFORMAT);
                    Organisation.this.chatverlauf.insertString(Organisation.this.chatverlauf.getLength(), text, null);
                }
                catch (BadLocationException exception) {
                    exception.printStackTrace();
                }
            }
        });
        AbstractDocument dokument = (AbstractDocument)this.eingabe.getDocument();
        dokument.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.kontrolliere();
            }

            private void kontrolliere() {
                Organisation.this.senden.setEnabled(!Organisation.this.eingabe.getText().isEmpty());
            }
        });
        dokument.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, 0, string, attr)) {
                    return;
                }
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, length, string, attr)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.replace(fb, offset, length, string, attr);
            }

            private boolean gefiltert(DocumentFilter.FilterBypass fb, int offset, int laenge, String string, AttributeSet attr) {
                boolean gefiltert;
                boolean bl = gefiltert = string != null && fb.getDocument().getLength() - laenge + string.length() > 60;
                if (gefiltert) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return gefiltert;
            }
        });
        this.eingabe.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    Organisation.this.senden.doClick();
                }
            }
        });
        this.senden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Organisation.this.firePropertyChange("Senden", null, Organisation.this.eingabe.getText());
                Organisation.this.eingabe.setText(null);
            }
        });
        this.tabelle.setModel(this.leitung);
    }

    private JPanel leiste() {
        this.aufnahme.setEnabled(false);
        this.aufnahme.setToolTipText("<html><p>Experimentell, daher deaktiviert!</p><p>Netzwerkbetrieb wird zurzeit nicht unterst\u00fctzt.</p></html>");
        this.aufnahme.addActionListener(this);
        this.aufnahme.addActionListener(this.leitung);
        this.abbruch.addActionListener(this);
        this.abbruch.addActionListener(this.leitung);
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(this.aufnahme);
        leiste.add(this.abbruch);
        return leiste;
    }

    private JScrollPane nachrichtenfeld() {
        JTextPane chatbereich = new JTextPane(this.chatverlauf);
        chatbereich.setPreferredSize(new Dimension(0, 100));
        chatbereich.setEditable(false);
        ((DefaultCaret)chatbereich.getCaret()).setUpdatePolicy(2);
        JScrollPane nachrichtenfeld = new JScrollPane(chatbereich);
        nachrichtenfeld.setToolTipText("Hier k\u00f6nnen alle bislang versendeten Nachrichten nachgelesen werden.");
        nachrichtenfeld.setBorder(BorderFactory.createTitledBorder("Empfangene Nachrichten"));
        return nachrichtenfeld;
    }

    private JScrollPane tabellenfeld() {
        this.tabelle.setPreferredScrollableViewportSize(new Dimension(0, 64));
        this.tabelle.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent zelle = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (row == 0) {
                    zelle.setForeground(Color.GRAY);
                    zelle.setToolTipText("Die Austragungst\u00e4tte vor Ort, an dessen Ger\u00e4t der oder die Teilnehmer direkt sitzen.");
                } else {
                    zelle.setForeground(Color.BLACK);
                    zelle.setToolTipText("Eine weitere im lokalen Netzwerk gefundene Austragungst\u00e4tte.");
                }
                return zelle;
            }
        });
        this.tabelle.setCellSelectionEnabled(false);
        this.tabelle.setFocusable(false);
        int spalte = 0;
        while (spalte < this.tabelle.getColumnCount()) {
            this.tabelle.getColumnModel().getColumn(spalte).setPreferredWidth(this.leitung.breite(spalte));
            ++spalte;
        }
        this.tabelle.getTableHeader().setReorderingAllowed(false);
        JScrollPane tabellenfeld = new JScrollPane(this.tabelle);
        tabellenfeld.setToolTipText("<html><p>Die Tabelle listet alle Austragungsst\u00e4tten von JaFuffy auf.</p><p>Diese m\u00f6chten \u00fcber das lokale Netzwerk am Turnier teilnehmen.</p><p>Die farblich hervorgehobene Austragungsst\u00e4tte bestimmt die Regeln.</p><p>Die Austragungst\u00e4tte vor Ort befindet sich in der ersten Zeile.</p></html>");
        tabellenfeld.setBorder(BorderFactory.createTitledBorder("Alle Austragungsst\u00e4tten"));
        tabellenfeld.setRowHeaderView(this.tabelle.getTableHeader());
        return tabellenfeld;
    }
}

