/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Wuerfelbild;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wuerfelreihe
extends JPanel
implements ChangeListener {
    private static final int MINDESTWUERFELABSTAND = 2;
    private Wuerfel[] wuerfelsatz;
    private final Wuerfelbild[] wuerfelbilder = new Wuerfelbild[5];

    Wuerfelreihe() {
        super(new BorderLayout());
        int i = 0;
        while (i < 5) {
            this.wuerfelbilder[i] = new Wuerfelbild(i);
            ++i;
        }
        this.add((Component)this.baue(), "Center");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            Turnier turnier = (Turnier)cej.quelle(Turnier.class);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.verwende(turnier.wuerfelsatz());
                }
                case SPIEL: 
                case GESETZT: {
                    this.akzeptiere(turnier.aktiver().neu());
                }
                case GEWUERFELT: 
                case RUECKGAENGIG: {
                    this.aktiviere(turnier.aktiver());
                    break;
                }
                case VORGESCHLAGEN: {
                    this.uebernehme();
                    break;
                }
                case PAUSE: {
                    this.pausiere();
                    break;
                }
            }
        }
    }

    private void aktiviere(Spieler aktiver) {
        boolean fertig = aktiver.rest() == 0;
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild wuerfelbild = wuerfelbildArray[n2];
            wuerfelbild.setEnabled(!fertig);
            ++n2;
        }
    }

    private void akzeptiere(boolean neu) {
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            bild.setEnabled(true);
            bild.setSelected(neu);
            ++n2;
        }
    }

    private JPanel baue() {
        JPanel wuerfelauswahl = new JPanel();
        wuerfelauswahl.setLayout(new BoxLayout(wuerfelauswahl, 0));
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            wuerfelauswahl.add(Box.createHorizontalGlue());
            wuerfelauswahl.add(Box.createHorizontalStrut(2));
            wuerfelauswahl.add(bild);
            wuerfelauswahl.add(Box.createHorizontalStrut(2));
            ++n2;
        }
        wuerfelauswahl.add(Box.createHorizontalGlue());
        return wuerfelauswahl;
    }

    private void pausiere() {
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            bild.setEnabled(false);
            bild.setSelected(false);
            ++n2;
        }
    }

    private void uebernehme() {
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            if (bild.isSelected() != bild.vorgeschlagen()) {
                bild.doClick();
            }
            ++n2;
        }
    }

    private void verwende(Wuerfel[] wuerfelsatz) {
        this.wuerfelsatz = wuerfelsatz;
        int w = 0;
        while (w < 5) {
            this.wuerfelbilder[w].verwende(wuerfelsatz[w]);
            ++w;
        }
    }

    void klicke(boolean ausgewaehlt) {
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            if (bild.isSelected() == ausgewaehlt) {
                bild.doClick();
            }
            ++n2;
        }
    }

    boolean selektiert() {
        boolean selektiert = false;
        Wuerfelbild[] wuerfelbildArray = this.wuerfelbilder;
        int n = this.wuerfelbilder.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfelbild bild = wuerfelbildArray[n2];
            selektiert = selektiert || bild.isSelected();
            ++n2;
        }
        return selektiert;
    }

    void sortiere() {
        Arrays.sort(this.wuerfelsatz);
        this.verwende(this.wuerfelsatz);
    }

    boolean sortiert() {
        boolean sortiert = true;
        int w = 0;
        while (w < 4) {
            sortiert = sortiert && this.wuerfelsatz[w].augen() <= this.wuerfelsatz[w + 1].augen();
            ++w;
        }
        return sortiert;
    }
}

