/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;
import jafuffy.bedienung.Ende;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Signal;
import jafuffy.bedienung.Willkommen;
import jafuffy.logik.Manager;
import jafuffy.logik.Statistik;
import jafuffy.logik.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.swing.JOptionPane;

public class JaFuffy {
    private static final String VERSION = "1.8";
    private static final String VERRIEGELUNGSDATEI = "JaFuffy.lock";

    public static void main(String[] args) {
        Eigenschaften eigenschaften;
        Oberflaeche.starteJetzt(new Runnable(){

            @Override
            public void run() {
                JaFuffy.pruefeKompatibilitaet();
            }
        });
        if (JaFuffy.verarbeiteArgumente(args)) {
            try {
                if (JaFuffy.mehrfachstart()) {
                    Dialoge.meldeMehrfachstart();
                    System.exit(0);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        if ((eigenschaften = Eigenschaften.GLOBAL).erststart()) {
            Willkommen willkommen = new Willkommen(eigenschaften);
            willkommen.dispose();
            if (willkommen.abgebrochen()) {
                System.exit(0);
            }
        }
        JaFuffy.registriereAufraeumer(eigenschaften);
        new JaFuffy(eigenschaften, JaFuffy.beschaffeStatistik());
    }

    private static Statistik beschaffeStatistik() {
        try {
            File datei = Eigenschaften.GLOBAL.datei("Statistik.obj");
            if (datei.exists()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(datei));
                    Statistik statistik = (Statistik)ois.readObject();
                    ois.close();
                    return statistik;
                }
                catch (IOException | ClassNotFoundException exception) {
                    exception.printStackTrace();
                    Signal.ALARM.play();
                    Dialoge.meldeFehlendeStatistikdaten(exception);
                }
            }
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen verbieten persistente Statistik: " + exception);
        }
        return new Statistik();
    }

    private static boolean mehrfachstart() throws IOException {
        String tmpdir;
        try {
            tmpdir = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException exception) {
            System.out.println("Per Java Web Start ausgef\u00fchrt (Heuristik): " + exception);
            return false;
        }
        final File datei = new File(tmpdir, VERRIEGELUNGSDATEI);
        final RandomAccessFile stream = new RandomAccessFile(datei, "rw");
        FileChannel kanal = stream.getChannel();
        FileLock riegel = kanal.tryLock();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    stream.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                datei.delete();
            }
        });
        return riegel == null;
    }

    private static void pruefeKompatibilitaet() {
        String version = System.getProperty("java.specification.version");
        double wert = Double.parseDouble(version);
        if (wert < Double.parseDouble(VERSION)) {
            Dialoge.meldeVersionsproblem(version, VERSION);
        }
    }

    private static void registriereAufraeumer(final Eigenschaften eigenschaften) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (eigenschaften.neustart()) {
                        try {
                            File jar = new File(JaFuffy.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                            try {
                                String java = String.valueOf(System.getProperty("java.home")) + "/bin/java";
                                StringBuffer cmd = new StringBuffer("\"" + java + "\"");
                                cmd.append(" -jar \"").append(jar.getPath()).append("\"");
                                Runtime.getRuntime().exec(cmd.toString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (URISyntaxException exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen verbieten automatischen Neustart: " + exception);
        }
    }

    private static boolean verarbeiteArgumente(String[] args) {
        boolean exklusiv = true;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals("nosound")) {
                Ressource.schalteStumm();
                System.out.println("Sound ist abgeschaltet");
            } else if (arg.equals("nolock")) {
                exklusiv = false;
                System.out.println("Mehrfachstartverriegelung ist abgeschaltet");
            }
            ++n2;
        }
        return exklusiv;
    }

    public JaFuffy(final Eigenschaften eigenschaften, final Statistik statistik) {
        Oberflaeche.starteSpaeter(new Runnable(){

            @Override
            public void run() {
                Fenster fenster = new Fenster("JaFuffy");
                Ende ende = new Ende(eigenschaften, statistik);
                fenster.addWindowListener(ende);
                Update update = new Update();
                new Manager(eigenschaften, statistik, fenster, ende, update);
                update.ueberpruefe(eigenschaften.aktiv("Nachschauen"), fenster);
            }
        });
    }

    private static class Dialoge
    extends JOptionPane {
        private static final long serialVersionUID = -7746203861656296567L;

        private Dialoge() {
        }

        static void meldeFehlendeStatistikdaten(Exception exception) {
            Dialoge.showMessageDialog(null, "Statistikdaten k\u00f6nnen nicht geladen werden!\nDatenverlust bei n\u00e4chster Sicherung m\u00f6glich.\nJava-Exception:\n" + exception, "JaFuffy (Hinweis)", 1);
        }

        static void meldeMehrfachstart() {
            Dialoge.showMessageDialog(null, "JaFuffy wurde offenbar schon gestartet!\nDiese Instanz beendet sich jetzt.", "JaFuffy (Hinweis)", 1);
        }

        static void meldeVersionsproblem(String version, String minimum) {
            JOptionPane.showMessageDialog(null, "Versionsanforderung nicht erf\u00fcllt!\nM\u00f6glicherweise treten Probleme auf.\n\nJava-Version " + version + " gefunden,\n" + "ben\u00f6tigt wird mindestens " + minimum + ".", "JaFuffy (Warnung)", 2);
        }
    }
}

