/******************************************************************************
 ** $Id: Hinweissteuerung.java 1212 2017-04-18 23:48:18Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.ToolTipManager;

/** Steuert die Anzeige von Hinweisen, beim Aufenthalt in einer Komponente werden die Hinweise immer angezeigt. */
class Hinweissteuerung extends MouseAdapter {

    private static final ToolTipManager TTM = ToolTipManager.sharedInstance();
    private static final int TTM_INIT_DELAY = TTM.getInitialDelay();
    private static final int TTM_DISMISS_DELAY = TTM.getDismissDelay();
    private static final int INIT_DELAY = 250;
    private static final int DISMISS_DELAY = 1500;

    /** Speichert, ob Hinweise generell in den Eigenschaften aktiviert sind. */
    private boolean aktiviert;

    @Override
    public void mouseEntered(MouseEvent event) {
        aktiviert = ToolTipManager.sharedInstance().isEnabled();
        TTM.setInitialDelay(INIT_DELAY);
        TTM.setDismissDelay(DISMISS_DELAY);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        TTM.setInitialDelay(TTM_INIT_DELAY);
        TTM.setDismissDelay(TTM_DISMISS_DELAY);
        ToolTipManager.sharedInstance().setEnabled(aktiviert);
    }

}
