/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.PackResources;
import com.izforge.izpack.util.os.FileQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.commons.io.IOUtils;

class Pack200FileUnpacker
extends FileUnpacker {
    public Pack200FileUnpacker(Cancellable cancellable, PackResources resources, FileQueue queue) {
        super(cancellable, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(PackFile packFile, InputStream packInputStream, File target) throws IOException, InstallerException {
        BufferedInputStream in = IOUtils.buffer(packInputStream);
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream(this.getTarget(packFile, target));
            Pack200.Unpacker unpacker = this.createPack200Unpacker(packFile);
            unpacker.unpack((InputStream)in, jarOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jarOut);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(jarOut);
        IOUtils.closeQuietly(in);
        this.postCopy(packFile);
    }

    private Pack200.Unpacker createPack200Unpacker(PackFile packFile) {
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        SortedMap defaultUnpackerProperties = unpacker.properties();
        Map<String, String> localPackerProperties = packFile.getPack200Properties();
        if (localPackerProperties != null) {
            defaultUnpackerProperties.putAll(localPackerProperties);
        }
        return unpacker;
    }
}

