/******************************************************************************
 ** $Id: Klassisch.java 1185 2017-04-15 22:36:22Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.auswertung;

import jafuffy.bedienung.Auswahl;
import jafuffy.logik.Analyse;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;

/** Klassische Auswertung. */
public class Klassisch extends Auswertung {

    /** Ermglicht Serialisierung. */
    private static final long serialVersionUID = -6095824767073891696L;

    /** Die Klasse der Auswahl, die zu dieser Auswertung passt. */
    public static final Class<? extends Auswahl> AUSWAHLKLASSE = jafuffy.bedienung.auswahl.Klassisch.class;
    /** Regelname. */
    public static final String REGEL = "Klassische Regeln";

    /** Standardabweichung als grobe Schtzung fr das mittlere Spielergebnis. */
    private static final int ABWEICHUNG = 45;
    /** Erwartete Punktzahl pro Spiel als grobe Schtzung. */
    private static final int MITTELWERT = 235;

    /**
     * Konstruktor.
     *
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     */
    public Klassisch(Wuerfel[] wuerfel) {
        this(wuerfel, new jafuffy.logik.analyse.Klassisch(wuerfel));
    }

    /**
     * Konstruktor.
     *
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     * @param analyse
     *            Das zur Analyse des Wurfs benutzte Objekt.
     */
    protected Klassisch(Wuerfel[] wuerfel, Analyse analyse) {
        super(wuerfel, analyse);
    }

    @Override
    public int abweichung() {
        return ABWEICHUNG;
    }

    @Override
    public int mittelwert() {
        return MITTELWERT;
    }

    @Override
    public String text(Tabzeile eintrag) {
        return null;
    }

    @Override
    public String toString() {
        return REGEL;
    }

}
