/******************************************************************************
 ** $Id$
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Ressource;

import java.awt.Image;
import java.awt.Toolkit;

import javax.swing.ImageIcon;

/** Erzeugung von Oberflchenobjekten fr die Anzeige von Bildern und Icons. */
final class Grafik {

    /**
     * Erzeugt ein Bild aus der gefundenen Ressource.
     *
     * @param name
     *            Name des Bildes
     * @return Bild
     */
    static Image bild(String name) {
        return Toolkit.getDefaultToolkit().getImage(Ressource.ICON.url(name));
    }

    /**
     * Erzeugt ein Icon aus der gefundenen Ressource.
     *
     * @param name
     *            Name des Icons
     * @return Icon
     */
    static ImageIcon icon(String name) {
        return new ImageIcon(Ressource.ICON.url(name));
    }

    /** Hilfsklasse, von der nie ein Objekt erzeugt wird. */
    private Grafik() {
    }

}
