/******************************************************************************
 ** $Id: Erster.java 1017 2016-05-28 20:35:09Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.logik.Spieler;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

/**
 * Wer beginnt das als erster das Spiel? Auswahl durch die Spieler oder Auswrfeln durch Computer.
 */
@SuppressWarnings("serial")
class Erster extends JDialog implements ActionListener {

    // Zufallszahl
    private static final Random ZUFALL = new Random();
    // Spielerffner
    private int erster = -1;
    // Mitspieler
    private final ArrayList<Spieler> spieler;

    /**
     * Konstruktor.
     *
     * @param spieler
     *            alle Mitspieler
     */
    Erster(ArrayList<Spieler> spieler) {

        this.spieler = spieler;

        // zufllig bestimmen
        JButton auswuerfeln = new JButton("zufllig bestimmen");
        auswuerfeln.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                erster = ZUFALL.nextInt(Erster.this.spieler.size());
            }
        });
        auswuerfeln.setToolTipText("Computer bestimmt, wer zuerst wrfelt");
        auswuerfeln.setMargin(new Insets(0, 15, 0, 15));

        // Spieler whlen selbst
        JPanel auswaehlen = new JPanel(new GridLayout(0, 1, 0, 4));
        for (int i = 0; i < spieler.size(); i++) {
            JButton button = new JButton(spieler.get(i).toString());
            button.setToolTipText(button.getText() + " wrfelt zuerst");
            button.setMargin(new Insets(3, 8, 3, 8));
            button.setActionCommand(String.valueOf(i));
            button.addActionListener(this);
            auswaehlen.add(button);
        }

        // Dialog aufbauen
        JPanel panel = new JPanel(new BorderLayout(5, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(12, 16, 12, 16));
        panel.add(auswaehlen, BorderLayout.WEST);
        panel.add(auswuerfeln, BorderLayout.CENTER);
        setContentPane(panel);
        getRootPane().setDefaultButton(auswuerfeln);

        // Dialog anzeigen
        setTitle("JaFuffy (Wer wrfelt zuerst?)");
        setIconImages(Oberflaeche.LOGOS);
        setModal(true);
        pack();
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        // Fokus aufs Auswrfeln setzen
        auswuerfeln.requestFocus();

    }

    /**
     * Bei einem Mitspieler nicht sichtbar machen (ignorieren)
     *
     * @param sichtbar
     */
    @Override
    public void setVisible(boolean sichtbar) {
        if (spieler.size() > 1) {
            super.setVisible(sichtbar);
        } else {
            erster = 0; // Ergebnis steht fest
        }
    }

    /**
     * Spieler ausgewhlt?
     *
     * @param e
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        erster = Integer.parseInt(e.getActionCommand());
    }

    /**
     * @return erster Spieler, der das Turnier erffnet
     */
    int erster() {
        return erster;
    }

}
