#include "Bleistift.inc"
 
background { LightBlue } 
global_settings { ambient_light rgb<1,1,1> }
light_source { <-20,40,-40> color White}
light_source { <20,20,20> color Gray10 shadowless }


camera {    
    location <150,80,-80>
    look_at  <20,10,0>
    angle 15
}

#if (clock < 2)
    object {
        bleistift    
        rotate <30+15*cos(pi*clock),15+7.5*sin(pi*clock),0>
        translate <4,0,-8+12*clock>
    }
#else
    object {
        bleistift    
        rotate <30+15,15+0,0>
        translate <4,0,16+24*(2-clock)>
    }
#end

polygon {
    4
    <20,0,15>,<-20,0,15>,<-20,0,-15>,<20,0,-15>
    texture {
        pigment { White }
    }
    finish {
        ambient <0.8,0.8,0.8>
    }
    translate <10,0,5>
}

text { ttf "timrom.ttf" "JaFuffy" 0.2,0
    pigment { Red }
    scale 4
    rotate <90,-90,0>
    translate <-6,0.2,-8>
}

text { ttf "timrom.ttf" "Erna  Erich  Christian  Wolfgang" 0.1,0
    pigment { Gray10 }
    scale 2
    rotate <90,-90,0>
    translate <-1.5,0.1,-8>
}