/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.JaFuffy;
import jafuffy.bedienung.Absprache;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Bestenliste;
import jafuffy.bedienung.Ende;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Fortsetzung;
import jafuffy.bedienung.Kommentierung;
import jafuffy.bedienung.Menue;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Report;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Spielplatz;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.Aufsicht;
import jafuffy.logik.Statistik;
import jafuffy.logik.Turnier;
import jafuffy.logik.Update;
import jafuffy.logik.Variante;
import jafuffy.logik.Wuerfel;
import javax.swing.SwingUtilities;

public class Manager {
    private final Absprache absprache;
    private final Ende ende;
    private final Fenster fenster;
    private final Fortsetzung fortsetzung;
    private final Menue menue;
    private final Spielplatz spielplatz;
    private final Aufsicht aufsicht;
    private final Statistik statistik;
    private Turnier turnier;
    private int vorgaengerspielerzahl;

    public Manager(Eigenschaften eigenschaften, Statistik statistik, Fenster fenster, Ende ende, Update update) {
        this(eigenschaften, statistik, fenster, ende, update, new Fortsetzung(eigenschaften, fenster));
        fenster.zeige(eigenschaften, this.menue, this.spielplatz);
        this.fortsetzung.addPropertyChangeListener("Speichern", this.menue);
        this.fortsetzung.verbinde(this);
        this.fortsetzung.versuche();
    }

    public Manager(Eigenschaften eigenschaften, Statistik statistik, JaFuffy jafuffy) {
        this(eigenschaften, statistik, null, null, null, null);
        jafuffy.zeige(this.menue, this.spielplatz);
    }

    private Manager(Eigenschaften eigenschaften, Statistik statistik, Fenster fenster, Ende ende, Update update, Fortsetzung fortsetzung) {
        this.statistik = statistik;
        this.fenster = fenster;
        this.ende = ende;
        this.fortsetzung = fortsetzung;
        Oberflaeche oberflaeche = new Oberflaeche(eigenschaften);
        this.absprache = new Absprache(eigenschaften, this);
        this.vorgaengerspielerzahl = 0;
        int i = 0;
        while (i < 4) {
            if (!eigenschaften.getProperty("Spieler" + i).equals("")) {
                ++this.vorgaengerspielerzahl;
            }
            ++i;
        }
        Becher becher = new Becher();
        Vorschlagen vorschlagen = new Vorschlagen();
        Setzen setzen = new Setzen();
        Verfolgung verfolgung = new Verfolgung();
        this.spielplatz = new Spielplatz(becher, verfolgung, setzen);
        this.aufsicht = new Aufsicht(eigenschaften, vorschlagen, becher, verfolgung, setzen);
        Report report = new Report(statistik);
        Bestenliste bestenliste = new Bestenliste(statistik, this.variantenindex(eigenschaften));
        this.menue = new Menue(vorschlagen, setzen, report, bestenliste, fortsetzung, update);
        Kommentierung kommentierung = new Kommentierung(this.spielplatz);
        statistik.addChangeListener(bestenliste);
        statistik.addChangeListener(report);
        statistik.addChangeListener(kommentierung);
        this.spielplatz.addPropertyChangeListener("Beginnen", this.absprache);
        this.menue.addPropertyChangeListener("LookAndFeel", oberflaeche);
        this.menue.addPropertyChangeListener("Beginnen", this.absprache);
        this.menue.addPropertyChangeListener("Karte", this.spielplatz);
    }

    public void betreibe(Turnier neu) {
        Wuerfel w;
        int n;
        int n2;
        Wuerfel[] wuerfelArray;
        if (this.turnier != null) {
            this.vorgaengerspielerzahl = this.turnier.spieler().size();
            this.turnier.beende();
            this.turnier.removeChangeListener(this.aufsicht);
            this.turnier.removeChangeListener(this.spielplatz);
            this.turnier.removeChangeListener(this.menue);
            this.turnier.removeChangeListener(this.ende);
            this.turnier.auswertung().removeChangeListener(this.spielplatz);
            wuerfelArray = this.turnier.wuerfel();
            n2 = wuerfelArray.length;
            n = 0;
            while (n < n2) {
                w = wuerfelArray[n];
                w.entferneChangeListener(this.spielplatz);
                ++n;
            }
            this.turnier.removeChangeListener(this.fortsetzung);
        }
        if (this.fenster != null) {
            this.fenster.setTitle("JaFuffy (" + neu.auswertung() + ")");
            if (this.vorgaengerspielerzahl != neu.spieler().size()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Manager.this.fenster.pack();
                    }
                });
            }
        }
        this.turnier = neu;
        this.turnier.setzeFort(this.statistik);
        this.turnier.addChangeListener(this.spielplatz);
        this.turnier.addChangeListener(this.menue);
        this.turnier.addChangeListener(this.ende);
        this.turnier.auswertung().addChangeListener(this.spielplatz);
        wuerfelArray = this.turnier.wuerfel();
        n2 = wuerfelArray.length;
        n = 0;
        while (n < n2) {
            w = wuerfelArray[n];
            w.installiereChangeListener(this.spielplatz);
            ++n;
        }
        this.turnier.addChangeListener(this.fortsetzung);
        this.turnier.addChangeListener(this.aufsicht);
        this.turnier.starte();
    }

    private int variantenindex(Eigenschaften eigenschaften) {
        int variante;
        try {
            variante = Variante.valueOf(eigenschaften.getProperty("Variante")).ordinal();
        }
        catch (IllegalArgumentException exeption) {
            variante = Variante.KLASSISCH.ordinal();
            System.out.println(exeption);
        }
        return variante;
    }
}

